/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.WipConsoleAPICalledKt;
import com.jetbrains.javascript.debugger.ConsoleMessage;
import com.jetbrains.javascript.debugger.ConsolePrinter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.protocol.log.LogEntryValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/debugger/wip/WipLogEntry;", "Lcom/jetbrains/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/log/LogEntryValue;", "request", "Lorg/jetbrains/wip/RequestInfo;", "(Lorg/jetbrains/wip/protocol/log/LogEntryValue;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "printer", "Lcom/jetbrains/javascript/debugger/ConsolePrinter;", "printFailedNetworkRequestMessage", "ChromeConnector"})
public final class WipLogEntry
implements ConsoleMessage {
    private final LogEntryValue message;
    private final RequestInfo request;

    /*
     * Unable to fully structure code
     */
    public void print(@NotNull ConsoleView consoleView, @NotNull ConsolePrinter printer) {
        block18: {
            Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
            Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
            url = this.message.getUrl();
            line = this.message.getLineNumber();
            v0 = this.message.getStackTrace();
            stackTrace = v0 != null ? v0.callFrames() : null;
            isFromNetwork = Intrinsics.areEqual((Object)this.message.source(), (Object)LogEntryValue.Source.NETWORK);
            if (isFromNetwork) {
                if (this.request == null) {
                    ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
                    v1 = this.message.getUrl();
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    printer.addFileLink(v1, -1, -1, (String)null, false);
                } else {
                    if (this.request.getInitiator() != null) {
                        v2 = this.request.getInitiator();
                        if (v2 == null) {
                            Intrinsics.throwNpe();
                        }
                        v3 = v2.getStack();
                        stackTrace = v3 != null ? v3.callFrames() : null;
                        v4 = this.request.getInitiator();
                        if (v4 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!StringUtil.isEmpty((String)v4.getUrl())) {
                            v5 = this.request.getInitiator();
                            if (v5 == null) {
                                Intrinsics.throwNpe();
                            }
                            url = v5.getUrl();
                            v6 = this.request.getInitiator();
                            if (v6 == null) {
                                Intrinsics.throwNpe();
                            }
                            line = (int)v6.getLineNumber();
                        }
                    }
                    if (Intrinsics.areEqual((Object)this.message.level(), (Object)LogEntryValue.Level.ERROR)) {
                        this.printFailedNetworkRequestMessage(printer);
                    } else {
                        ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
                    }
                }
            } else {
                ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
            }
            if (isFromNetwork && this.request == null) break block18;
            v7 = stackTrace;
            v8 = callFrame = v7 != null ? (CallFrameValue)CollectionsKt.firstOrNull(v7) : null;
            if (callFrame == null) ** GOTO lbl-1000
            var8_8 = callFrame.url();
            if (!(var8_8 == null || var8_8.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                printer.addFileLink(callFrame.url(), callFrame.getLineNumber(), callFrame.getColumnNumber(), callFrame.functionName(), isFromNetwork == false);
            } else lbl-1000:
            // 2 sources

            {
                var8_8 = url;
                if (!(var8_8 == null || var8_8.length() == 0) && Intrinsics.areEqual((Object)url, (Object)"undefined") ^ true) {
                    v9 = url;
                    if (v9 == null) {
                        Intrinsics.throwNpe();
                    }
                    printer.addFileLink(v9, line - 1, 0, (String)null, isFromNetwork == false);
                }
            }
        }
        printer.newLine();
        if (isFromNetwork || Intrinsics.areEqual((Object)this.message.level(), (Object)LogEntryValue.Level.ERROR)) {
            v10 = contentType = Intrinsics.areEqual((Object)this.message.level(), (Object)LogEntryValue.Level.ERROR) != false ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"contentType");
            WipConsoleAPICalledKt.printStackTrace(consoleView, printer, v10, stackTrace);
        }
    }

    private final void printFailedNetworkRequestMessage(ConsolePrinter printer) {
        RequestInfo requestInfo = this.request;
        if (requestInfo == null) {
            Intrinsics.throwNpe();
        }
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    public WipLogEntry(@NotNull LogEntryValue message, @Nullable RequestInfo request) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
        this.request = request;
    }
}

