/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.WipConsoleAPICalled$WhenMappings;
import com.jetbrains.debugger.wip.WipConsoleAPICalledKt;
import com.jetbrains.javascript.debugger.ConsoleMessage;
import com.jetbrains.javascript.debugger.ConsolePrinter;
import com.jetbrains.javascript.debugger.GlobalEvaluator;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventDataType;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/debugger/wip/WipConsoleAPICalled;", "Lcom/jetbrains/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;", "(Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;)V", "print", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "printer", "Lcom/jetbrains/javascript/debugger/ConsolePrinter;", "printParameters", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "isNotFirst", "", "ChromeConnector"})
public final class WipConsoleAPICalled
implements ConsoleMessage {
    private final ConsoleAPICalledEventData message;

    public void print(@NotNull ConsoleView consoleView, @NotNull ConsolePrinter printer) {
        CallFrameValue callFrame;
        Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        StackTraceValue stackTraceValue = this.message.getStackTrace();
        List<CallFrameValue> stackTrace = stackTraceValue != null ? stackTraceValue.callFrames() : null;
        ConsoleViewContentType contentType = Intrinsics.areEqual((Object)((Object)this.message.type()), (Object)((Object)ConsoleAPICalledEventDataType.ERROR)) ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
        switch (WipConsoleAPICalled$WhenMappings.$EnumSwitchMapping$0[this.message.type().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                if (Intrinsics.areEqual((Object)((Object)this.message.type()), (Object)((Object)ConsoleAPICalledEventDataType.END_GROUP))) {
                    printer.groupEnd();
                } else {
                    printer.groupStart();
                }
                ConsoleViewContentType consoleViewContentType = contentType;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                this.printParameters(printer, consoleViewContentType, false);
                break;
            }
            case 4: 
            case 5: {
                return;
            }
            case 6: {
                printer.clear();
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)ConsolePrinter.Companion.getCONSOLE_INFO_KEY());
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026Printer.CONSOLE_INFO_KEY)");
                printer.append("Console was cleared", consoleViewContentType);
                break;
            }
            default: {
                if (Intrinsics.areEqual((Object)((Object)this.message.type()), (Object)((Object)ConsoleAPICalledEventDataType.ASSERT))) {
                    ConsoleViewContentType consoleViewContentType = contentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                    printer.append("Assertion failed:", consoleViewContentType);
                    ConsoleViewContentType consoleViewContentType2 = contentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"contentType");
                    this.printParameters(printer, consoleViewContentType2, true);
                    break;
                }
                ConsoleViewContentType consoleViewContentType = contentType;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
                this.printParameters(printer, consoleViewContentType, false);
            }
        }
        List<CallFrameValue> list = stackTrace;
        CallFrameValue callFrameValue = callFrame = list != null ? (CallFrameValue)CollectionsKt.firstOrNull(list) : null;
        if (callFrame != null) {
            CharSequence charSequence = callFrame.url();
            if (!(charSequence == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                printer.addFileLink(callFrame.url(), callFrame.getLineNumber(), callFrame.getColumnNumber(), callFrame.functionName(), true);
            }
        }
        printer.newLine();
        if (Intrinsics.areEqual((Object)((Object)this.message.type()), (Object)((Object)ConsoleAPICalledEventDataType.ERROR)) || Intrinsics.areEqual((Object)((Object)this.message.type()), (Object)((Object)ConsoleAPICalledEventDataType.TRACE))) {
            ConsoleViewContentType consoleViewContentType = contentType;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"contentType");
            WipConsoleAPICalledKt.printStackTrace(consoleView, printer, consoleViewContentType, stackTrace);
        }
    }

    private final void printParameters(ConsolePrinter printer, ConsoleViewContentType contentType, boolean isNotFirst) {
        boolean isNotFirst2 = isNotFirst;
        JavaScriptDebugProcess debugProcess = printer.getDebugProcess();
        Vm vm = debugProcess.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        EvaluateContext evaluateContext2 = vm.getEvaluateContext();
        if (evaluateContext2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
        }
        ValueManager valueManager = ((EvaluateContextBase)evaluateContext2).getValueManager();
        if (valueManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
        }
        WipValueManager valueManager2 = (WipValueManager)valueManager;
        for (RemoteObjectValue objectValue : this.message.args()) {
            if (isNotFirst2) {
                printer.append(" ", contentType);
            } else {
                isNotFirst2 = true;
            }
            CharSequence charSequence = objectValue.getObjectId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                GlobalEvaluator globalEvaluator = debugProcess.getGlobalEvaluator();
                Value value = valueManager2.createValue(objectValue);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                globalEvaluator.printAndStoreValueToInspect(value, (String)null, contentType);
                continue;
            }
            if (objectValue.value() != null) {
                printer.append(String.valueOf(objectValue.value()), contentType);
                continue;
            }
            if (StringUtil.isEmpty((String)objectValue.getDescription())) continue;
            String string = objectValue.getDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.append(string, contentType);
        }
    }

    public WipConsoleAPICalled(@NotNull ConsoleAPICalledEventData message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
    }
}

