/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ExecutionResult;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcessKt;
import com.jetbrains.debugger.wip.BrowserJavaScriptDebuggerViewSupport;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.WipSuspendContextView;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.jetbrains.javascript.debugger.JavaScriptLineBreakpointManager;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContext;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.ExecutionStackView;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.SuspendContextViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.JSExecutionStackSuspendContext;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextManager;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J(\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0014\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/debugger/wip/BrowserChromeDebugProcess;", "Lcom/jetbrains/debugger/wip/ChromeDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/impl/DebuggableFileFinder;", "connection", "Lorg/jetbrains/debugger/connection/VmConnection;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/impl/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "beforeInitBreakpoints", "", "vm", "Lorg/jetbrains/debugger/Vm;", "createDebuggerViewSupport", "Lcom/jetbrains/javascript/debugger/JavaScriptDebuggerViewSupport;", "createSuspendContext", "Lcom/jetbrains/javascript/debugger/JavaScriptSuspendContext;", "context", "Lorg/jetbrains/debugger/SuspendContext;", "script", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "normalizeMemberNameIfNotProcessedByDebugAware", "", "kotlin.jvm.PlatformType", "name", "ChromeConnector"})
public class BrowserChromeDebugProcess
extends ChromeDebugProcess {
    protected void beforeInitBreakpoints(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        if (Registry.is((String)"js.debugger.chrome.use.any.breakpoint", (boolean)true)) {
            JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default((JavaScriptLineBreakpointManager)this.getLineBreakpointManager(), (Vm)vm, (String)"^[^/\\\\]+-\\d+\\.([jJ][sS])$", null, (int)4, null);
        }
        super.beforeInitBreakpoints(vm);
    }

    @NotNull
    protected JavaScriptDebuggerViewSupport createDebuggerViewSupport() {
        return new BrowserJavaScriptDebuggerViewSupport(this);
    }

    protected String normalizeMemberNameIfNotProcessedByDebugAware(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return BrowserChromeDebugProcessKt.access$getHEX_POSTFIX_PATTERN$p().matcher(name).replaceAll("");
    }

    @NotNull
    protected JavaScriptSuspendContext createSuspendContext(@NotNull SuspendContext<?> context, @Nullable Script script, @Nullable SourceInfo topFrameSourceInfo) {
        SuspendContextManager suspendContextManager;
        WipSuspendContextView wipSuspendContextView;
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        XSuspendContext created = this.getSession().getSuspendContext();
        XSuspendContext xSuspendContext = created;
        if (!(xSuspendContext instanceof WipSuspendContextView)) {
            xSuspendContext = null;
        }
        if ((wipSuspendContextView = (WipSuspendContextView)xSuspendContext) == null) {
            wipSuspendContextView = new WipSuspendContextView(this, new ExecutionStackView(context, (DebuggerViewSupport)this.getDebuggerViewSupport(), script, topFrameSourceInfo, SuspendContextViewKt.MAIN_LOOP_NAME));
        }
        WipSuspendContextView result = wipSuspendContextView;
        result.addSuspendContext(context, script, topFrameSourceInfo);
        Vm vm = this.getConnection().getVm();
        Object object = suspendContextManager = vm != null ? vm.getSuspendContextManager() : null;
        if (suspendContextManager instanceof WipSuspendContextManager && context instanceof WipSuspendContext) {
            if (created == null) {
                for (JSExecutionStackSuspendContext<WipSuspendContext, WipCallFrame> stack : ((WipSuspendContextManager)suspendContextManager).getThreadSuspendContexts().values()) {
                    result.addSuspendContext((SuspendContext)stack.getSuspendContext(), stack.getScript(), (SourceInfo)stack.getAdditionalData());
                }
            }
            JSExecutionStackSuspendContext stackContext = new JSExecutionStackSuspendContext((SuspendContextBase)context, script, topFrameSourceInfo);
            Map<String, JSExecutionStackSuspendContext<WipSuspendContext, WipCallFrame>> map = ((WipSuspendContextManager)suspendContextManager).getThreadSuspendContexts();
            String string = context.getWorkerId();
            if (string == null) {
                string = "";
            }
            map.put(string, stackContext);
        }
        return result;
    }

    public BrowserChromeDebugProcess(@NotNull XDebugSession session2, @NotNull DebuggableFileFinder finder, @NotNull VmConnection<?> connection, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)finder, (String)"finder");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        super(session2, finder, connection, executionResult);
        this.setElementsInspectorEnabled(true);
    }

    public /* synthetic */ BrowserChromeDebugProcess(XDebugSession xDebugSession, DebuggableFileFinder debuggableFileFinder, VmConnection vmConnection, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executionResult = null;
        }
        this(xDebugSession, debuggableFileFinder, vmConnection, executionResult);
    }
}

