/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetType;
import com.intellij.jam.JamElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistenceFacetType;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistenceModelBrowserImpl
implements PersistenceModelBrowser {
    public static final PersistenceModelBrowserImpl INSTANCE = new PersistenceModelBrowserImpl();
    private Condition<PersistenceClassRole> myFilter;
    private static final Key<CachedValue<AttributeInfo>> MEMBER_PERSISTENT_ATTRIBUTES_KEY = Key.create((String)"MEMBER_PERSISTENT_ATTRIBUTES_KEY");
    private static final Key<CachedValue<Map<XmlFile, Collection<PersistencePackage>>>> PERSISTENCE_UNITS_KEY = Key.create((String)"PERSISTENCE_UNITS_KEY");

    @NotNull
    public PersistenceModelBrowser setRoleFilter(Condition<PersistenceClassRole> filter) {
        assert (this != INSTANCE);
        this.myFilter = filter;
        PersistenceModelBrowserImpl persistenceModelBrowserImpl = this;
        if (persistenceModelBrowserImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "setRoleFilter"));
        }
        return persistenceModelBrowserImpl;
    }

    public boolean acceptsRole(PersistenceClassRole role) {
        return this.myFilter == null || this.myFilter.value((Object)role);
    }

    @NotNull
    public Query<PersistentObject> queryPersistentObjectHierarchy(PersistentObject obj) {
        ExecutorsQuery executorsQuery = new ExecutorsQuery((Object)obj, Collections.singletonList(new QueryExecutor<PersistentObject, PersistentObject>(){

            public boolean execute(@NotNull PersistentObject queryParameters, @NotNull Processor<PersistentObject> consumer) {
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceModelBrowserImpl$1", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$1", "execute"));
                }
                PsiClass firstClass = (PsiClass)queryParameters.getClazz().getValue();
                if (firstClass == null) {
                    return consumer.process((Object)queryParameters);
                }
                if (!consumer.process((Object)queryParameters)) {
                    return false;
                }
                Ref first = Ref.create((Object)Boolean.FALSE);
                SmartList superClasses = new SmartList();
                Processor processor = aClass -> {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$1", "lambda$execute$0"));
                    }
                    if (firstClass.equals(aClass)) {
                        first.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return PersistenceModelBrowserImpl.this.queryPersistentObjects((PsiClass)aClass).forEach(consumer);
                };
                if (!JamCommonUtil.processSuperClassList((PsiClass)firstClass.getSuperClass(), (Collection)superClasses, (Processor)processor)) {
                    return (Boolean)first.get();
                }
                return true;
            }
        }));
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistentObjectHierarchy"));
        }
        return executorsQuery;
    }

    @NotNull
    public Query<PersistentAttribute> queryAttributes(PersistentObject obj) {
        QueryExecutor<PersistentAttribute, PersistentObject> queryExecutor = new QueryExecutor<PersistentAttribute, PersistentObject>(){

            public boolean execute(@NotNull PersistentObject queryParameters, @NotNull Processor<PersistentAttribute> consumer) {
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceModelBrowserImpl$2", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$2", "execute"));
                }
                THashSet visitedNames = new THashSet();
                return PersistenceModelBrowserImpl.this.queryPersistentObjectHierarchy(queryParameters).forEach(persistentObject -> {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$2", "lambda$execute$0"));
                    }
                    for (PersistentAttribute attribute : persistentObject.getObjectModelHelper().getAttributes()) {
                        if (attribute instanceof JamElement && attribute.getPsiMember() instanceof PsiMethod && !visitedNames.add(attribute.getName().getValue()) || consumer.process((Object)attribute)) continue;
                        return false;
                    }
                    return true;
                });
            }
        };
        ExecutorsQuery executorsQuery = new ExecutorsQuery((Object)obj, Collections.singletonList(queryExecutor));
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryAttributes"));
        }
        return executorsQuery;
    }

    @NotNull
    public Query<PersistentObject> queryTargetPersistentObjects(PersistentRelationshipAttribute attribute) {
        Query<PersistentObject> query = this.queryPersistentObjects(PersistenceCommonUtil.getTargetClass((PersistentRelationshipAttribute)attribute), PersistenceClassRoleEnum.ENTITY);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTargetPersistentObjects"));
        }
        return query;
    }

    @NotNull
    public Query<PersistentObject> queryTargetPersistentObjects(PersistentEmbeddedAttribute attribute) {
        if (attribute instanceof PersistentEmbeddable) {
            ArrayQuery arrayQuery = new ArrayQuery((Object[])new PersistentObject[]{(PersistentObject)attribute});
            if (arrayQuery == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTargetPersistentObjects"));
            }
            return arrayQuery;
        }
        Query<PersistentObject> query = this.queryPersistentObjects(PersistenceCommonUtil.getTargetClass((PersistentEmbeddedAttribute)attribute), PersistenceClassRoleEnum.EMBEDDABLE);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTargetPersistentObjects"));
        }
        return query;
    }

    @NotNull
    public Query<PersistenceListener> queryPersistenceListeners(PsiClass psiClass) {
        if (psiClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistenceListeners"));
            }
            return query;
        }
        ExecutorsQuery executorsQuery = new ExecutorsQuery((Object)psiClass, Collections.singletonList(new QueryExecutor<PersistenceListener, PsiClass>(){

            public boolean execute(@NotNull PsiClass queryParameters, @NotNull Processor<PersistenceListener> consumer) {
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceModelBrowserImpl$3", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$3", "execute"));
                }
                for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)queryParameters)) {
                    PersistenceListener listener = role.getEntityListener();
                    if (listener == null || PersistenceModelBrowserImpl.this.myFilter != null && !PersistenceModelBrowserImpl.this.myFilter.value((Object)role) || consumer.process((Object)listener)) continue;
                    return false;
                }
                return true;
            }
        }));
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistenceListeners"));
        }
        return executorsQuery;
    }

    @NotNull
    public Query<PersistentObject> queryPersistentObjects(PsiClass psiClass) {
        Query<PersistentObject> query = this.queryPersistentObjects(psiClass, null);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistentObjects"));
        }
        return query;
    }

    @NotNull
    public Query<PersistentObject> queryPersistentObjects(PsiClass psiClass, final PersistenceClassRoleEnum type) {
        if (psiClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistentObjects"));
            }
            return query;
        }
        ExecutorsQuery executorsQuery = new ExecutorsQuery((Object)psiClass, Collections.singletonList(new QueryExecutor<PersistentObject, PsiClass>(){

            public boolean execute(@NotNull PsiClass queryParameters, @NotNull Processor<PersistentObject> consumer) {
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceModelBrowserImpl$4", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$4", "execute"));
                }
                for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)queryParameters)) {
                    PersistentObject object = role.getPersistentObject();
                    if (object == null || PersistenceModelBrowserImpl.this.myFilter != null && !PersistenceModelBrowserImpl.this.myFilter.value((Object)role) || type != null && type != role.getType() || consumer.process((Object)object)) continue;
                    return false;
                }
                return true;
            }
        }));
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistentObjects"));
        }
        return executorsQuery;
    }

    @NotNull
    public Query<PersistentRelationshipAttribute> queryTheOtherSideAttributes(PersistentRelationshipAttribute relationAttribute, final boolean inverseOnly) {
        PsiMember thisMember = relationAttribute.getPsiMember();
        if (thisMember == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTheOtherSideAttributes"));
            }
            return query;
        }
        PsiClass thisClass = thisMember.getContainingClass();
        if (thisClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTheOtherSideAttributes"));
            }
            return query;
        }
        SmartList queryExecutors = new SmartList();
        for (final PersistentObject object : this.queryTargetPersistentObjects(relationAttribute)) {
            queryExecutors.add((Object)new QueryExecutor<PersistentRelationshipAttribute, PersistentRelationshipAttribute>(){

                public boolean execute(@NotNull PersistentRelationshipAttribute queryParameters, @NotNull Processor<PersistentRelationshipAttribute> consumer) {
                    if (queryParameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceModelBrowserImpl$5", "execute"));
                    }
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$5", "execute"));
                    }
                    return PersistenceModelBrowserImpl.this.queryTheOtherSideAttributes(queryParameters, inverseOnly, object).forEach(consumer);
                }
            });
        }
        ExecutorsQuery executorsQuery = new ExecutorsQuery((Object)relationAttribute, (List)queryExecutors);
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTheOtherSideAttributes"));
        }
        return executorsQuery;
    }

    @NotNull
    public Query<PersistentRelationshipAttribute> queryTheOtherSideAttributes(PersistentRelationshipAttribute relationAttribute, final boolean inverseOnly, final PersistentObject targetEntity) {
        boolean thisInverse = relationAttribute.getAttributeModelHelper().isInverseSide();
        if (inverseOnly && thisInverse) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTheOtherSideAttributes"));
            }
            return query;
        }
        PsiMember thisMember = relationAttribute.getPsiMember();
        if (thisMember == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTheOtherSideAttributes"));
            }
            return query;
        }
        final PsiClass thisClass = thisMember.getContainingClass();
        if (thisClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTheOtherSideAttributes"));
            }
            return query;
        }
        final String thisName = (String)relationAttribute.getName().getValue();
        final String thisMappedBy = relationAttribute.getAttributeModelHelper().getMappedByAttributeName();
        ExecutorsQuery executorsQuery = new ExecutorsQuery((Object)relationAttribute, Collections.singletonList(new QueryExecutor<PersistentRelationshipAttribute, PersistentRelationshipAttribute>(){

            public boolean execute(@NotNull PersistentRelationshipAttribute queryParameters, @NotNull Processor<PersistentRelationshipAttribute> consumer) {
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceModelBrowserImpl$6", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$6", "execute"));
                }
                if (targetEntity != null) {
                    PersistenceModelBrowserImpl.this.queryAttributes(targetEntity).forEach(attributeBase -> {
                        if (consumer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$6", "lambda$execute$0"));
                        }
                        if (attributeBase instanceof PersistentRelationshipAttribute) {
                            PersistentRelationshipAttribute targetAttribute = (PersistentRelationshipAttribute)attributeBase;
                            PsiClass targetTargetClass = (PsiClass)targetAttribute.getTargetEntityClass().getValue();
                            if (!thisClass.getManager().areElementsEquivalent((PsiElement)thisClass, (PsiElement)targetTargetClass)) {
                                return true;
                            }
                            boolean thatInverse = targetAttribute.getAttributeModelHelper().isInverseSide();
                            if (inverseOnly && !thatInverse) {
                                return true;
                            }
                            String thatMappedBy = targetAttribute.getAttributeModelHelper().getMappedByAttributeName();
                            if ((thisMappedBy != null && thisMappedBy.equals(attributeBase.getName().getValue()) || thatMappedBy != null && thatMappedBy.equals(thisName)) && !consumer.process((Object)targetAttribute)) {
                                return false;
                            }
                        }
                        return true;
                    });
                }
                return true;
            }
        }));
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryTheOtherSideAttributes"));
        }
        return executorsQuery;
    }

    @NotNull
    public List<PersistentAttribute> getPersistenceAttributes(PsiMember psiMember) {
        if (psiMember == null || !psiMember.isValid()) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
            }
            return list;
        }
        AttributeInfo attributeInfo = PersistenceModelBrowserImpl.getAttributeInfo(psiMember.getContainingClass());
        if (attributeInfo == null) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
            }
            return list;
        }
        Collection<PersistentAttribute> attributes = attributeInfo.memberAttributes.get(psiMember);
        SmartList smartList = attributes == null ? Collections.emptyList() : new SmartList(attributes);
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
        }
        return smartList;
    }

    @NotNull
    public List<PersistentAttribute> getPersistenceAttributes(PersistentObject object, PsiMember psiMember) {
        Collection<? extends PersistentAttribute> attributes2;
        if (!(object != null && object.isValid() || psiMember != null && psiMember.isValid())) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
            }
            return list;
        }
        PsiClass psiClass = psiMember != null ? psiMember.getContainingClass() : (PsiClass)object.getClazz().getValue();
        AttributeInfo attributeInfo = PersistenceModelBrowserImpl.getAttributeInfo(psiClass);
        if (attributeInfo == null) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
            }
            return list;
        }
        Collection<PersistentAttribute> attributes1 = psiMember == null ? null : attributeInfo.memberAttributes.get(psiMember);
        Collection<? extends PersistentAttribute> collection = attributes2 = object == null ? null : attributeInfo.objectAttributes.get(object);
        if (attributes1 == null) {
            ArrayList<? extends PersistentAttribute> arrayList = attributes2 == null || psiMember != null ? Collections.emptyList() : new ArrayList<PersistentAttribute>(attributes2);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
            }
            return arrayList;
        }
        if (attributes2 == null) {
            ArrayList<PersistentAttribute> arrayList = object != null ? Collections.emptyList() : new ArrayList<PersistentAttribute>(attributes1);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
            }
            return arrayList;
        }
        ArrayList<PersistentAttribute> result = new ArrayList<PersistentAttribute>(attributes2);
        result.retainAll(attributes1);
        ArrayList<PersistentAttribute> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceAttributes"));
        }
        return arrayList;
    }

    @Nullable
    private static AttributeInfo getAttributeInfo(PsiClass aClass) {
        if (aClass == null || !aClass.isValid()) {
            return null;
        }
        PsiClass originalClass = (PsiClass)aClass.getOriginalElement();
        PsiClass containingClass = originalClass != null ? originalClass : aClass;
        CachedValue data = (CachedValue)containingClass.getUserData(MEMBER_PERSISTENT_ATTRIBUTES_KEY);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)containingClass.getProject()).createCachedValue(() -> {
                PersistenceClassRole[] classRoles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)containingClass);
                if (classRoles.length == 0) {
                    return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                HashSet<Object> dependencyItemsList = new HashSet<Object>();
                dependencyItemsList.add(containingClass);
                AttributeInfo info = null;
                for (PersistenceClassRole classRole : classRoles) {
                    PersistentObject persistentObject = classRole.getPersistentObject();
                    if (persistentObject == null) continue;
                    if (info == null) {
                        info = new AttributeInfo();
                        info.memberAttributes = new THashMap();
                        info.objectAttributes = new THashMap();
                    }
                    PersistenceFacet facet = classRole.getFacet();
                    dependencyItemsList.add(facet.getModificationTracker());
                    List attributes = persistentObject.getObjectModelHelper().getAttributes();
                    info.objectAttributes.put(persistentObject, attributes);
                    for (PersistentAttribute attributeBase : attributes) {
                        PsiMember member;
                        if (attributeBase instanceof PersistentTransientAttribute || (member = attributeBase.getPsiMember()) == null) continue;
                        THashSet attrs = info.memberAttributes.get(member);
                        if (attrs == null) {
                            attrs = new THashSet();
                            info.memberAttributes.put(member, (Collection<PersistentAttribute>)attrs);
                        }
                        attrs.add((PersistentAttribute)attributeBase);
                    }
                }
                Object[] dependencyItems = dependencyItemsList.toArray();
                return new CachedValueProvider.Result(info, dependencyItems);
            }, false);
            containingClass.putUserData(MEMBER_PERSISTENT_ATTRIBUTES_KEY, (Object)data);
        }
        return (AttributeInfo)data.getValue();
    }

    @NotNull
    public List<PersistenceFacet> getPersistenceFacets(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceFacets"));
        }
        ArrayList<PersistenceFacet> result = new ArrayList<PersistenceFacet>();
        Module module = unit.getModule();
        List facets = module == null ? PersistenceCommonUtil.getAllPersistenceFacets((Project)unit.getPsiManager().getProject()) : PersistenceCommonUtil.getAllPersistenceFacets((Module)module);
        for (PersistenceFacet facet : facets) {
            if (!facet.getPersistenceUnits().contains(unit)) continue;
            result.add(facet);
        }
        ArrayList<PersistenceFacet> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceFacets"));
        }
        return arrayList;
    }

    @NotNull
    public List<PersistencePackage> getPersistenceUnits(PersistenceMappings mappings) {
        if (mappings instanceof JamElement) {
            Module module = mappings.getModule();
            ArrayList<PersistencePackage> result = new ArrayList<PersistencePackage>();
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Module)module)) {
                if (facet.getAnnotationEntityMappings() == null) continue;
                result.addAll(facet.getPersistenceUnits());
            }
            ArrayList<PersistencePackage> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceUnits"));
            }
            return arrayList;
        }
        if (mappings instanceof DomElement) {
            Map map;
            XmlFile xmlFile = DomUtil.getFile((DomElement)((DomElement)mappings));
            if (!xmlFile.isValid()) {
                List<PersistencePackage> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceUnits"));
                }
                return list;
            }
            Project project = (xmlFile = (XmlFile)xmlFile.getOriginalFile()).getProject();
            CachedValue value = (CachedValue)project.getUserData(PERSISTENCE_UNITS_KEY);
            if (value == null) {
                value = CachedValuesManager.getManager((Project)xmlFile.getProject()).createCachedValue(() -> {
                    THashSet depSet = new THashSet();
                    FacetFinder facetFinder = FacetFinder.getInstance((Project)project);
                    for (FacetType facetType : (FacetType[])FacetType.EP_NAME.getExtensions()) {
                        if (!(facetType instanceof PersistenceFacetType)) continue;
                        depSet.add(facetFinder.getAllFacetsOfTypeModificationTracker(facetType.getId()));
                    }
                    THashMap result = new THashMap();
                    for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Project)project)) {
                        for (PersistencePackage unit : facet.getPersistenceUnits()) {
                            ContainerUtil.addIfNotNull((Collection)depSet, (Object)unit.getContainingFile());
                            for (PersistenceMappings mappings1 : PersistenceCommonUtil.getDomEntityMappings(PersistenceMappings.class, (PersistencePackage)unit, (PersistenceFacet)facet)) {
                                XmlFile xmlFile1 = DomUtil.getFile((DomElement)((DomElement)mappings1));
                                Collection persistenceUnits = (Collection)result.get((Object)xmlFile1);
                                if (persistenceUnits == null) {
                                    persistenceUnits = new THashSet();
                                    result.put((Object)xmlFile1, (Object)persistenceUnits);
                                }
                                persistenceUnits.add(unit);
                            }
                        }
                    }
                    Object[] dependencyObjects = depSet.toArray();
                    return new CachedValueProvider.Result((Object)result, dependencyObjects);
                }, false);
                project.putUserData(PERSISTENCE_UNITS_KEY, (Object)value);
            }
            if ((map = (Map)value.getValue()) == null) {
                List<PersistencePackage> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceUnits"));
                }
                return list;
            }
            Collection units = (Collection)map.get(xmlFile);
            if (units == null) {
                List<PersistencePackage> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceUnits"));
                }
                return list;
            }
            ArrayList<PersistencePackage> arrayList = new ArrayList<PersistencePackage>(units);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "getPersistenceUnits"));
            }
            return arrayList;
        }
        throw new AssertionError();
    }

    @NotNull
    public Query<PersistenceFacet> queryPersistenceFacets(final PsiElement element) {
        if (element == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistenceFacets"));
            }
            return query;
        }
        ExecutorsQuery executorsQuery = new ExecutorsQuery((Object)element, Collections.singletonList(new QueryExecutor<PersistenceFacet, PsiElement>(){

            public boolean execute(@NotNull PsiElement queryParameters, @NotNull Processor<PersistenceFacet> consumer) {
                Module module;
                PsiClass psiClass;
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceModelBrowserImpl$7", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceModelBrowserImpl$7", "execute"));
                }
                PsiFile containingFile = element.getContainingFile();
                if (containingFile instanceof XmlFile) {
                    DomElement rootElement;
                    for (PersistenceFacet curFacet : PersistenceCommonUtil.getAllPersistenceFacets((Project)element.getProject())) {
                        for (ConfigFile configFile : curFacet.getDescriptors()) {
                            if (!element.getManager().areElementsEquivalent((PsiElement)configFile.getPsiFile(), (PsiElement)containingFile) || consumer.process((Object)curFacet)) continue;
                            return false;
                        }
                        for (PersistencePackage unit : curFacet.getPersistenceUnits()) {
                            if (!element.getManager().areElementsEquivalent((PsiElement)unit.getContainingFile(), (PsiElement)containingFile) || consumer.process((Object)curFacet)) continue;
                            return false;
                        }
                    }
                    DomFileElement fileElement = DomManager.getDomManager((Project)element.getProject()).getFileElement((XmlFile)containingFile, DomElement.class);
                    if (fileElement != null && (rootElement = fileElement.getRootElement()) instanceof PersistenceMappings) {
                        List<PersistencePackage> units = PersistenceModelBrowserImpl.this.getPersistenceUnits((PersistenceMappings)rootElement);
                        for (PersistencePackage unit : units) {
                            if (ContainerUtil.process(PersistenceModelBrowserImpl.this.getPersistenceFacets(unit), consumer)) continue;
                            return false;
                        }
                    }
                } else if (element.getLanguage() == StdFileTypes.JAVA.getLanguage() && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null) {
                    PersistenceClassRole[] roles;
                    for (PersistenceClassRole role : roles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
                        if (consumer.process((Object)role.getFacet())) continue;
                        return false;
                    }
                }
                if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)element)) != null) {
                    List facets = PersistenceCommonUtil.getAllPersistenceFacets((Module)module);
                    return ContainerUtil.process((List)facets, consumer);
                }
                return true;
            }
        }));
        if (executorsQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceModelBrowserImpl", "queryPersistenceFacets"));
        }
        return executorsQuery;
    }

    private static class AttributeInfo {
        Map<PsiMember, Collection<PersistentAttribute>> memberAttributes;
        Map<PersistentObject, Collection<? extends PersistentAttribute>> objectAttributes;

        private AttributeInfo() {
        }
    }
}

