/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceMessages;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JdbcPropertiesDataSourceDetector
extends DataSourceDetector {
    public void collectDataSources(@NotNull Project project, final @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/persistence/JdbcPropertiesDataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/persistence/JdbcPropertiesDataSourceDetector", "collectDataSources"));
        }
        PropertiesReferenceManager.getInstance((Project)project).processAllPropertiesFiles(new PropertiesFileProcessor(){

            public boolean process(String baseName, PropertiesFile propertiesFile) {
                builder.withName(propertiesFile.getVirtualFile().getNameWithoutExtension());
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.DRIVER_CLASS, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.driver", (Object[])new Object[0]));
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.URL, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.url", (Object[])new Object[0]));
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.USERNAME, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.user", (Object[])new Object[0]));
                JdbcPropertiesDataSourceDetector.collect(builder, DataSourceDetector.Property.PASSWORD, propertiesFile, PersistenceMessages.message((String)"import.aliases.jdbc.password", (Object[])new Object[0]));
                builder.commit("jdbc.properties", (Object)propertiesFile.getContainingFile());
                return true;
            }
        });
    }

    private static void collect(@NotNull DataSourceDetector.Builder b, @NotNull DataSourceDetector.Property p, @NotNull PropertiesFile propertiesFile, @NonNls String keys) {
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/persistence/JdbcPropertiesDataSourceDetector", "collect"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/persistence/JdbcPropertiesDataSourceDetector", "collect"));
        }
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/intellij/persistence/JdbcPropertiesDataSourceDetector", "collect"));
        }
        for (String key : StringUtil.split((String)keys, (String)",", (boolean)true, (boolean)true)) {
            IProperty property = propertiesFile.findPropertyByKey(key);
            if (property == null) continue;
            b.with(p, property.getValue());
        }
    }
}

