/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr.gradle;

import com.intellij.facet.FacetType;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.initializr.SpringInitializrModuleBuilderPostTask;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.io.File;
import java.util.List;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportProvider;

public class SpringInitializrGradleModuleBuilderPostTask
extends SpringInitializrModuleBuilderPostTask {
    @Override
    public boolean runAfterSetup(Module module) {
        Project project = module.getProject();
        File gradleFile = null;
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            File baseDir = VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
            File file = new File(baseDir, "build.gradle");
            if (!file.exists()) continue;
            gradleFile = file;
            break;
        }
        if (gradleFile == null) {
            return true;
        }
        ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        GradleProjectImportBuilder gradleProjectImportBuilder = new GradleProjectImportBuilder(projectDataManager);
        GradleProjectImportProvider gradleProjectImportProvider = new GradleProjectImportProvider(gradleProjectImportBuilder);
        AddModuleWizard wizard = new AddModuleWizard(project, gradleFile.getPath(), new ProjectImportProvider[]{gradleProjectImportProvider});
        if (wizard.getStepCount() <= 0 || wizard.showAndGet()) {
            List committedModules = gradleProjectImportBuilder.commit(project, null, null);
            if (committedModules != null) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    for (Module committedModule : committedModules) {
                        List springBootApplications;
                        if (SpringCommonUtils.hasSpringFacet((Module)committedModule) || (springBootApplications = SpringBootApplicationUtil.getSpringApplications((Module)committedModule)).isEmpty()) continue;
                        FacetUtil.addFacet((Module)committedModule, (FacetType)SpringFacet.getSpringFacetType());
                        break;
                    }
                }));
            }
            return false;
        }
        return true;
    }
}

