/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ZipAndQueue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceLoginTicketsListener
extends VirtualFileAdapter {
    @Nullable
    private static final String ourP4TicketsFile = PerforceLoginTicketsListener.calculateAndNotify();
    private final AtomicReference<String> myLoadedText;
    private final PerforceLoginManager myLoginManager;
    private final ZipAndQueue myZipAndQueue;

    @Nullable
    private static String calculateAndNotify() {
        String value = PerforceLoginTicketsListener.calculatePath();
        if (value == null) {
            Notifications.Bus.notify((Notification)new Notification(PerforceVcs.getKey().getName(), "Perforce login monitor failure", "Perforce can not find where tickets file is.\nAuthentication state would be refreshed only during Perforce operations.", NotificationType.ERROR));
            return null;
        }
        try {
            value = new File(value).getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            value = value.replace('\\', '/');
        }
        return value;
    }

    @Nullable
    private static String calculatePath() {
        String ticketsFilePath = EnvironmentUtil.getValue((String)"P4TICKETS");
        if (!StringUtil.isEmptyOrSpaces((String)ticketsFilePath)) {
            return ticketsFilePath;
        }
        if (SystemInfo.isWindows) {
            String userProfile = EnvironmentUtil.getValue((String)"USERPROFILE");
            return StringUtil.isEmptyOrSpaces((String)userProfile) ? null : new File(userProfile, "p4tickets.txt").getPath();
        }
        String home = EnvironmentUtil.getValue((String)"HOME");
        return StringUtil.isEmptyOrSpaces((String)home) ? null : new File(home, ".p4tickets").getPath();
    }

    public void pingListening() {
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(ourP4TicketsFile));
    }

    public PerforceLoginTicketsListener(Project project, PerforceLoginManager loginManager) {
        this.myLoginManager = loginManager;
        this.myLoadedText = new AtomicReference();
        this.myZipAndQueue = new ZipAndQueue(project, -1, "Perforce: refresh authentication state", () -> this.myLoginManager.refreshLoginState());
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/login/PerforceLoginTicketsListener", "propertyChanged"));
        }
        this.processEvent((VirtualFileEvent)event);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/login/PerforceLoginTicketsListener", "contentsChanged"));
        }
        this.processEvent(event);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/login/PerforceLoginTicketsListener", "fileCreated"));
        }
        this.processEvent(event);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/login/PerforceLoginTicketsListener", "fileDeleted"));
        }
        this.processEvent(event);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/login/PerforceLoginTicketsListener", "fileMoved"));
        }
        this.processEvent((VirtualFileEvent)event);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/perforce/login/PerforceLoginTicketsListener", "fileCopied"));
        }
        this.processEvent((VirtualFileEvent)event);
    }

    public static boolean shouldRegister() {
        return ourP4TicketsFile != null;
    }

    public void stop() {
        this.myZipAndQueue.stop();
    }

    private void processEvent(VirtualFileEvent event) {
        if (ourP4TicketsFile == null) {
            return;
        }
        String path = event.getFile().getPath();
        if (SystemInfo.isWindows && path.equalsIgnoreCase(ourP4TicketsFile) || path.equals(ourP4TicketsFile)) {
            try {
                File file = new File(ourP4TicketsFile);
                char[] text = file.exists() ? FileUtil.loadFileText((File)file) : ArrayUtil.EMPTY_CHAR_ARRAY;
                String asString = String.valueOf(text);
                String was = this.myLoadedText.getAndSet(asString);
                if (!asString.equals(was)) {
                    this.myZipAndQueue.request();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

