/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

class LoginNotifier
extends GenericNotifierImpl<P4Connection, ConnectionId> {
    private static final String INSPECT = "inspect";
    private static final String FIX = "fix";
    private final PerforceLoginManager myLoginManager;

    LoginNotifier(Project project, PerforceLoginManager loginManager) {
        super(project, "Perforce", "Perforce connection problems", NotificationType.ERROR);
        this.myLoginManager = loginManager;
    }

    @NotNull
    protected String getNotificationContent(P4Connection connection) {
        String workingDir = connection.getWorkingDir();
        String string = (workingDir == null ? "" : "Cannot connect to Perforce at " + workingDir + "<br>") + "<a href=\"" + FIX + "\">Enable login authentication</a><br><a href=\"" + INSPECT + "\">Inspect</a> connection state";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/login/LoginNotifier", "getNotificationContent"));
        }
        return string;
    }

    protected boolean ask(P4Connection obj, String description) {
        if (FIX.equals(description)) {
            PerforceSettings.getSettings((Project)this.myProject).USE_LOGIN = true;
            PerforceConnectionManager.getInstance(this.myProject).updateConnections();
            return this.myLoginManager.checkAndRepair(obj);
        }
        if (INSPECT.equals(description)) {
            PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, true);
            return false;
        }
        return false;
    }

    @NotNull
    protected ConnectionId getKey(P4Connection obj) {
        ConnectionId connectionId = obj.getId();
        if (connectionId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/login/LoginNotifier", "getKey"));
        }
        return connectionId;
    }
}

