/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldValue;
import org.jetbrains.idea.perforce.perforce.jobs.StandardJobFields;

public class PerforceJob {
    private final P4Connection myConnection;
    private final ConnectionKey myKey;
    private final Map<Integer, PerforceJobFieldValue> myStandardFields;
    private final Map<Integer, PerforceJobFieldValue> myOtherFields;

    public PerforceJob(List<PerforceJobFieldValue> standardFields, List<PerforceJobFieldValue> otherFields, @NotNull P4Connection connection, ConnectionKey key) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/perforce/jobs/PerforceJob", "<init>"));
        }
        this.myKey = key;
        this.myStandardFields = new HashMap<Integer, PerforceJobFieldValue>(standardFields.size(), 1.0f);
        this.myOtherFields = new HashMap<Integer, PerforceJobFieldValue>(otherFields.size(), 1.0f);
        this.myConnection = connection;
        for (PerforceJobFieldValue field : standardFields) {
            this.myStandardFields.put(field.getField().getCode(), field);
        }
        for (PerforceJobFieldValue field : otherFields) {
            this.myOtherFields.put(field.getField().getCode(), field);
        }
    }

    public PerforceJobFieldValue getValueForStandardField(StandardJobFields id) {
        return this.myStandardFields.get(id.getFixedCode());
    }

    public String getName() {
        return this.getNameValue().getValue();
    }

    public PerforceJobFieldValue getNameValue() {
        return this.getValueForStandardField(StandardJobFields.name);
    }

    @NotNull
    public P4Connection getConnection() {
        P4Connection p4Connection = this.myConnection;
        if (p4Connection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/jobs/PerforceJob", "getConnection"));
        }
        return p4Connection;
    }

    public ConnectionKey getConnectionKey() {
        return this.myKey;
    }
}

