/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.operations.P4RevertOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;

public class PerforceOfflineRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceOfflineRollbackEnvironment");
    private final Project myProject;

    public PerforceOfflineRollbackEnvironment(Project project) {
        this.myProject = project;
    }

    public String getRollbackOperationName() {
        return PerforceBundle.message((String)"operation.name.revert", (Object[])new Object[0]);
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> _exceptions, final @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/perforce/application/PerforceOfflineRollbackEnvironment", "rollbackChanges"));
        }
        final List<VcsException> exceptions = Collections.synchronizedList(_exceptions);
        ArrayList<WriteAction> actions = new ArrayList<WriteAction>();
        for (final Change c : changes) {
            final ContentRevision beforeRevision = c.getBeforeRevision();
            if (beforeRevision != null) {
                try {
                    String content;
                    boolean isRenameOrMove;
                    VirtualFile file;
                    final ContentRevision afterRevision = c.getAfterRevision();
                    if (afterRevision != null && !afterRevision.getFile().equals(beforeRevision.getFile())) {
                        file = afterRevision.getFile().getVirtualFile();
                        isRenameOrMove = true;
                    } else {
                        file = beforeRevision.getFile().getVirtualFile();
                        isRenameOrMove = false;
                    }
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("before rollback " + c + "; " + beforeRevision);
                        if (file != null) {
                            this.LOG.debug("has last content " + (LastUnchangedContentTracker.getLastUnchangedContent((VirtualFile)file) != null));
                        }
                    }
                    if ((content = beforeRevision.getContent()) != null && file != null) {
                        actions.add(new WriteAction(){

                            protected void run(@NotNull Result result) throws Throwable {
                                if (result == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/perforce/application/PerforceOfflineRollbackEnvironment$1", "run"));
                                }
                                if (PerforceOfflineRollbackEnvironment.this.myProject.isDisposed()) {
                                    return;
                                }
                                listener.accept(c);
                                VcsOperationLog.getInstance(PerforceOfflineRollbackEnvironment.this.myProject).addToLog(new P4RevertOperation(c));
                                try {
                                    file.setWritable(true);
                                    VfsUtil.saveText((VirtualFile)file, (String)content);
                                    if (isRenameOrMove) {
                                        PerforceOfflineRollbackEnvironment.this.handleMoveRename(beforeRevision, file, afterRevision);
                                    }
                                    file.setWritable(false);
                                }
                                catch (IOException e) {
                                    exceptions.add(new VcsException((Throwable)e));
                                }
                            }
                        });
                        continue;
                    }
                    this.LOG.debug("contentUnavailable: content " + (content != null) + ", file " + file);
                    exceptions.add(PerforceOfflineRollbackEnvironment.contentUnavailable(beforeRevision.getFile().getPath()));
                }
                catch (VcsException ex) {
                    exceptions.add(ex);
                }
                continue;
            }
            VcsOperationLog.getInstance(this.myProject).addToLog(new P4RevertOperation(c));
        }
        PerforceOfflineRollbackEnvironment.executeActions(listener, exceptions, actions);
    }

    private static void executeActions(RollbackProgressListener listener, List<VcsException> exceptions, List<WriteAction> actions) {
        if (!exceptions.isEmpty()) {
            return;
        }
        listener.determinate();
        for (WriteAction action : actions) {
            action.execute();
        }
    }

    private static VcsException contentUnavailable(String file) {
        return new VcsException("Cannot revert file " + file + ": original content is not available offline");
    }

    private void handleMoveRename(ContentRevision beforeRevision, VirtualFile file, ContentRevision afterRevision) throws IOException {
        String oldName = beforeRevision.getFile().getName();
        FilePath oldParentPath = beforeRevision.getFile().getParentPath();
        VirtualFile newParent = file.getParent();
        if (oldParentPath != null && newParent != null && !FileUtil.toSystemIndependentName((String)oldParentPath.getPath()).equals(newParent.getPath())) {
            File oldParentFile = new File(oldParentPath.getPath());
            oldParentFile.mkdirs();
            VirtualFile oldParentVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(oldParentFile);
            if (oldParentVFile != null) {
                file.move((Object)this, oldParentVFile);
            }
        }
        if (!file.getName().equals(oldName)) {
            file.rename((Object)this, oldName);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(beforeRevision.getFile());
        VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(afterRevision.getFile());
    }

    public void rollbackMissingFileDeletion(List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        throw new UnsupportedOperationException();
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, List<VcsException> _exceptions, final RollbackProgressListener listener) {
        final List<VcsException> exceptions = Collections.synchronizedList(_exceptions);
        ArrayList<WriteAction> actions = new ArrayList<WriteAction>();
        for (final VirtualFile file : files) {
            final byte[] content = LastUnchangedContentTracker.getLastUnchangedContent((VirtualFile)file);
            if (content == null) {
                exceptions.add(PerforceOfflineRollbackEnvironment.contentUnavailable(file.getPath()));
                continue;
            }
            actions.add(new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/perforce/application/PerforceOfflineRollbackEnvironment$2", "run"));
                    }
                    if (PerforceOfflineRollbackEnvironment.this.myProject.isDisposed()) {
                        return;
                    }
                    PerforceOfflineRollbackEnvironment.this.LOG.debug("rollbackModifiedWithoutCheckout file = " + file);
                    listener.accept(file);
                    try {
                        ((NewVirtualFile)file).setWritable(true);
                        file.setBinaryContent(content);
                        ((NewVirtualFile)file).setWritable(false);
                        VcsDirtyScopeManager.getInstance((Project)PerforceOfflineRollbackEnvironment.this.myProject).fileDirty(file);
                    }
                    catch (IOException e) {
                        exceptions.add(new VcsException((Throwable)e));
                    }
                }
            });
        }
        PerforceOfflineRollbackEnvironment.executeActions(listener, exceptions, actions);
    }
}

