/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.NumberNameModifier;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;

public class PerforceNumberNameMap
implements NumberNameModifier {
    private final MultiMap<String, Long> myNameToNumber = MultiMap.createSet();
    private final Map<Long, String> myNumberToName = ContainerUtil.newHashMap();

    void cleanup() {
        Set names = this.myNameToNumber.keySet();
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!this.myNameToNumber.get((Object)name).isEmpty()) continue;
            iterator.remove();
        }
    }

    public String getName(@NotNull Long number) {
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "getName"));
        }
        return this.myNumberToName.get(number);
    }

    @Override
    public void put(@NotNull String name, @NotNull Long nativeNumber) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "put"));
        }
        if (nativeNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeNumber", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "put"));
        }
        this.myNumberToName.put(nativeNumber, name);
        this.myNameToNumber.putValue((Object)name, (Object)nativeNumber);
    }

    public Collection<Long> getNumbers(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "getNumbers"));
        }
        return new ArrayList<Long>(this.myNameToNumber.get((Object)name));
    }

    @Override
    public void remove(@NotNull String name, @NotNull Long nativeNumber) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "remove"));
        }
        if (nativeNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeNumber", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "remove"));
        }
        this.myNumberToName.remove(nativeNumber);
        this.myNameToNumber.get((Object)name).remove(nativeNumber);
    }

    Set<String> removeEmpty(Collection<PerforceChangeList> existing) {
        HashSet<Long> orphanNumbers = new HashSet<Long>(this.myNumberToName.keySet());
        for (PerforceChangeList pair : existing) {
            orphanNumbers.remove(pair.getNumber());
        }
        HashSet<String> result = new HashSet<String>();
        HashSet onStartNames = new HashSet(this.myNameToNumber.keySet());
        for (Long number : orphanNumbers) {
            this.myNumberToName.remove(number);
            for (String key : onStartNames) {
                if (!this.myNameToNumber.containsKey((Object)key)) continue;
                this.myNameToNumber.remove((Object)key, (Object)number);
            }
        }
        for (String name : onStartNames) {
            Collection clNumbers = this.myNameToNumber.get((Object)name);
            if (!clNumbers.isEmpty()) continue;
            result.add(name);
            this.myNameToNumber.remove((Object)name);
        }
        return result;
    }

    @Override
    public void removeListIfEmpty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "removeListIfEmpty"));
        }
        Collection numbers = this.myNameToNumber.get((Object)name);
        if (numbers.isEmpty()) {
            this.myNameToNumber.remove((Object)name);
        }
    }

    @Override
    public boolean haveSingleAssociation(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "haveSingleAssociation"));
        }
        return this.myNameToNumber.get((Object)name).size() == 1;
    }

    @Override
    public void rename(@NotNull String from, @NotNull String to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "rename"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "rename"));
        }
        Collection associated = this.myNameToNumber.remove((Object)from);
        if (associated == null) {
            return;
        }
        this.myNameToNumber.put((Object)to, associated);
        for (Long number : associated) {
            this.myNumberToName.put(number, to);
        }
    }

    @Override
    public void add(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/perforce/application/PerforceNumberNameMap", "add"));
        }
        if (!this.myNameToNumber.containsKey((Object)name)) {
            this.myNameToNumber.put((Object)name, new HashSet());
        }
    }
}

