/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.P4RootsInformationHolder;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceInfoAndClient;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceBaseInfoWorker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker");
    private long myLastValidTime = -1L;
    private final PerforceConnectionManagerI myConnectionManager;
    private final PerforceSettings mySettings;
    private PerforceClientRootsChecker myChecker = new PerforceClientRootsChecker();
    private WeakHashMap<P4Connection, ConnectionInfo> myInfos = new WeakHashMap();
    private final Object myInfoLock = new Object();
    private final Object myRefreshLock = new Object();
    private boolean myIsDirty;
    private boolean myStop;
    private final PerforceConnectionProblemsNotifier myNotifier;
    private final PerforceLoginManager myLoginManager;
    private volatile boolean myInsideRefresh;

    public PerforceBaseInfoWorker(Project project, PerforceConnectionManagerI connectionManager, PerforceConnectionProblemsNotifier notifier, PerforceLoginManager loginManager) {
        this.myNotifier = notifier;
        this.myLoginManager = loginManager;
        this.myLoginManager.addSuccessfulLoginListener(() -> {
            Object object = this.myInfoLock;
            synchronized (object) {
                if (this.myChecker.hasNotAuthorized()) {
                    this.scheduleRefresh();
                }
            }
        });
        this.myConnectionManager = connectionManager;
        this.mySettings = PerforceSettings.getSettings(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<P4Connection, ConnectionInfo> refreshInfo() throws VcsException {
        PerforceInfoAndClient.RefreshInfo refreshInfo;
        WeakHashMap<P4Connection, ConnectionInfo> old;
        if (!this.mySettings.ENABLED) {
            return Collections.emptyMap();
        }
        Object object = this.myInfoLock;
        synchronized (object) {
            old = this.myInfos;
            if (!this.myIsDirty) {
                return old;
            }
        }
        Object object2 = this.myRefreshLock;
        synchronized (object2) {
            this.myInsideRefresh = true;
            try {
                refreshInfo = this.doRefreshInfo((Map<P4Connection, ConnectionInfo>)old);
            }
            finally {
                this.myInsideRefresh = false;
            }
        }
        return refreshInfo.newInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerforceInfoAndClient.RefreshInfo doRefreshInfo(Map<P4Connection, ConnectionInfo> old) {
        Map<VirtualFile, P4Connection> allConnections = this.myConnectionManager.getAllConnections();
        PerforceInfoAndClient.RefreshInfo refreshInfo = this.recalculateInfo(allConnections, old);
        PerforceClientRootsChecker checker = new PerforceClientRootsChecker(refreshInfo.newInfo, allConnections);
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myIsDirty = false;
            this.myInfos = new WeakHashMap(refreshInfo.newInfo);
            this.myChecker = checker;
            if (!refreshInfo.hasAnyErrorsBesidesAuthentication) {
                this.myLastValidTime = System.currentTimeMillis();
            }
        }
        LOG.debug("info+client calculated: " + refreshInfo);
        this.notifyAboutErrors(checker, refreshInfo);
        return refreshInfo;
    }

    private PerforceInfoAndClient.RefreshInfo recalculateInfo(Map<VirtualFile, P4Connection> allConnections, Map<P4Connection, ConnectionInfo> old) {
        Project project = this.mySettings.getProject();
        PerforceRunner runner = PerforceRunner.getInstance(project);
        ClientRootsCache cache = ClientRootsCache.getClientRootsCache(project);
        return PerforceInfoAndClient.recalculateInfos(old, allConnections.values(), runner, cache);
    }

    private void notifyAboutErrors(PerforceClientRootsChecker checker, PerforceInfoAndClient.RefreshInfo refreshInfo) {
        if (checker.isServerUnavailable()) {
            this.myNotifier.setProblems(true, true);
        } else {
            this.myNotifier.setProblems(false, checker.hasAnyErrors() || refreshInfo.hasAnyErrorsBesidesAuthentication);
        }
        if (checker.hasNotAuthorized()) {
            for (P4Connection connection : checker.getNotAuthorized()) {
                this.myLoginManager.getNotifier().ensureNotify(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRefresh() {
        if (this.myInsideRefresh) {
            return;
        }
        LOG.debug("Schedule refresh: ", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myLastValidTime = -1L;
            this.myIsDirty = true;
        }
    }

    @Nullable
    public Map<String, List<String>> getInfo(P4Connection connection) throws VcsException {
        ConnectionInfo info = this.getInfoAndClient(connection);
        return info == null ? null : info.getInfo();
    }

    @Nullable
    public Map<String, List<String>> getClient(P4Connection connection) throws VcsException {
        ConnectionInfo info = this.getInfoAndClient(connection);
        return info == null ? null : info.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, List<String>> getCachedInfo(P4Connection connection) throws VcsException {
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                return null;
            }
            ConnectionInfo info = (ConnectionInfo)this.myInfos.get((Object)connection);
            if (info == null) {
                LOG.debug("No info for " + connection + "; infos=" + this.myInfos);
                return null;
            }
            return info.getInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, List<String>> getCachedClient(P4Connection connection) throws VcsException {
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                return null;
            }
            ConnectionInfo info = (ConnectionInfo)this.myInfos.get((Object)connection);
            Map<String, List<String>> map = info == null ? null : info.getClient();
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ConnectionInfo getInfoAndClient(P4Connection connection) throws VcsException {
        boolean dirty;
        ConnectionInfo info;
        Object object = this.myInfoLock;
        synchronized (object) {
            if (this.myStop) {
                return null;
            }
            info = (ConnectionInfo)this.myInfos.get((Object)connection);
            dirty = this.myIsDirty;
            if (!dirty && info != null) {
                return info;
            }
        }
        if (dirty) {
            info = this.refreshInfo().get(connection);
        }
        if (info == null) {
            Project project = this.mySettings.getProject();
            info = PerforceInfoAndClient.calcInfo(connection, PerforceRunner.getInstance(project), ClientRootsCache.getClientRootsCache(project));
            Object object2 = this.myInfoLock;
            synchronized (object2) {
                this.myInfos.put((Object)connection, (Object)info);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.debug("stop", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myStop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOG.debug("start", new Throwable());
        Object object = this.myInfoLock;
        synchronized (object) {
            this.myStop = false;
            this.myLastValidTime = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastValidTime() {
        Object object = this.myInfoLock;
        synchronized (object) {
            return this.myLastValidTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P4RootsInformation getCheckerResults() {
        Object object = this.myInfoLock;
        synchronized (object) {
            return new P4RootsInformationHolder(this.myChecker.getErrors(), this.myChecker.getMap(), this.myChecker.getNotAuthorized());
        }
    }
}

