/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.idea.perforce.application.ListModification;
import org.jetbrains.idea.perforce.application.NumberNameModifier;

public class ModifyName
implements ListModification<ModifyName> {
    private final String myOldName;
    private final String myOldComment;
    private final String myNewName;
    private final Long myNumber;

    public ModifyName(String oldName, String newName, Long number, String oldComment) {
        this.myOldName = oldName;
        this.myNewName = newName;
        this.myNumber = number;
        this.myOldComment = oldComment;
    }

    @Override
    public void execute(Project project, ChangeListManagerGate gate, NumberNameModifier modifier) {
        LocalChangeList changeList = gate.findChangeList(this.myOldName);
        if (changeList != null) {
            modifier.add(this.myNewName);
            modifier.remove(this.myOldName, this.myNumber);
            modifier.put(this.myNewName, this.myNumber);
            gate.findOrCreateList(this.myNewName, this.myOldComment);
            if (changeList.isDefault()) {
                gate.setDefaultChangeList(this.myNewName);
            }
        }
    }

    @Override
    public boolean doesNothing() {
        return Comparing.equal((String)this.myNewName, (String)this.myOldName);
    }

    public String getOldName() {
        return this.myOldName;
    }
}

