/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public class ForceRefreshAction
extends DumbAwareAction {
    public ForceRefreshAction() {
        super("Force Refresh", "Force Refresh (re-query all files states)", AllIcons.Actions.ForceRefresh);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PerforceVcs vcs = PerforceVcs.getInstance(project);
        ((PerforceChangeProvider)vcs.getChangeProvider()).discardCache();
    }

    public void update(AnActionEvent e) {
        AbstractVcs vcs;
        Project project = e.getProject();
        if (project == null || !PerforceSettings.getSettings((Project)project).ENABLED) {
            e.getPresentation().setVisible(false);
            return;
        }
        AbstractVcs[] vcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        boolean shouldBeVisible = false;
        VcsKey key = PerforceVcs.getKey();
        AbstractVcs[] abstractVcsArray = vcss;
        int n = abstractVcsArray.length;
        for (int i = 0; !(i >= n || (vcs = abstractVcsArray[i]) != null && (shouldBeVisible = key.equals((Object)vcs.getKeyInstanceMethod()))); ++i) {
        }
        e.getPresentation().setVisible(shouldBeVisible);
    }
}

