/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.Collections;
import java.util.List;

public class GetSignaturesDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("PackageManagerGetSignatures", "Potential Multiple Certificate Exploit", "Improper validation of app signatures could lead to issues where a malicious app submits itself to the Play Store with both its real certificate and a fake certificate and gains access to functionality or information it shouldn't have due to another application only checking for the fake certificate and ignoring the rest. Please make sure to validate all signatures returned by this method.", Category.SECURITY, 8, Severity.INFORMATIONAL, new Implementation(GetSignaturesDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://bluebox.com/technical/android-fake-id-vulnerability/");
    private static final String PACKAGE_MANAGER_CLASS = "android.content.pm.PackageManager";
    private static final String GET_PACKAGE_INFO = "getPackageInfo";
    private static final int GET_SIGNATURES_FLAG = 64;

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_PACKAGE_INFO);
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        PsiExpression second;
        Object number;
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.methodMatches(method, PACKAGE_MANAGER_CLASS, true, "java.lang.String", "int")) {
            return;
        }
        PsiExpression[] arguments = node.getArgumentList().getExpressions();
        if (arguments.length == 2 && (number = ConstantEvaluator.evaluate(context, (PsiElement)(second = arguments[1]))) instanceof Number) {
            int flagValue = ((Number)number).intValue();
            GetSignaturesDetector.maybeReportIssue(flagValue, context, node, second);
        }
    }

    private static void maybeReportIssue(int flagValue, JavaContext context, PsiMethodCallExpression node, PsiExpression last) {
        if ((flagValue & 0x40) != 0) {
            context.report(ISSUE, (PsiElement)node, context.getLocation((PsiElement)last), "Reading app signatures from getPackageInfo: The app signatures could be exploited if not validated properly; see issue explanation for details.");
        }
    }
}

