/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CordovaVersionDetector
extends Detector
implements Detector.ClassScanner {
    private static final Implementation IMPL = new Implementation(CordovaVersionDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.JAVA_LIBRARIES));
    public static final Issue ISSUE = Issue.create("VulnerableCordovaVersion", "Vulnerable Cordova Version", "The version of Cordova used in the app is vulnerable to security issues. Please update to the latest Apache Cordova version.", Category.SECURITY, 9, Severity.WARNING, IMPL).addMoreInfo("https://cordova.apache.org/announcements/2015/11/20/security.html");
    private static final GradleVersion VALID_CORDOVA_VERSION = GradleVersion.parse((String)"4.1.1");
    private static final Pattern VERSION_STR = Pattern.compile("(\\d+\\.\\d+\\.\\d+).*");
    private static final String FQN_CORDOVA_DEVICE = "org/apache/cordova/Device";
    private static final String FIELD_NAME_CORDOVA_VERSION = "cordovaVersion";
    private static final String FQN_CORDOVA_WEBVIEW = "org/apache/cordova/CordovaWebView";
    private static final String FIELD_NAME_CORDOVA_VERSION_WEBVIEW = "CORDOVA_VERSION";
    private static final String CORDOVA_DOT_JS = "cordova.js";
    private static final FilenameFilter CORDOVA_JS_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String filename) {
            return filename.startsWith(CordovaVersionDetector.CORDOVA_DOT_JS) || new File(dir, filename).isDirectory();
        }
    };
    private GradleVersion mCordovaVersion;

    @Override
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public void afterCheckProject(Context context) {
        this.checkAssetsFolder(context);
    }

    private void checkAssetsFolder(Context context) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        Project project = context.getProject();
        List<File> assetFolders = project.getAssetFolders();
        ArrayDeque<File> files = new ArrayDeque<File>();
        for (File assetFolder : assetFolders) {
            files.push(assetFolder);
            while (!files.isEmpty() && this.mCordovaVersion == null) {
                File current = (File)files.pop();
                if (current.isDirectory()) {
                    File[] filtered = current.listFiles(CORDOVA_JS_FILTER);
                    if (filtered == null) continue;
                    for (File file : filtered) {
                        files.push(file);
                    }
                    continue;
                }
                this.checkFile(context, current);
            }
            files.clear();
        }
    }

    private void checkFile(Context context, File file) {
        if (this.mCordovaVersion == null && file.getPath().contains(CORDOVA_DOT_JS) && file.getName().startsWith(CORDOVA_DOT_JS)) {
            try {
                this.mCordovaVersion = (GradleVersion)Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new JsVersionLineProcessor());
                if (this.mCordovaVersion != null) {
                    CordovaVersionDetector.validateCordovaVersion(context, this.mCordovaVersion, Location.create(file));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void validateCordovaVersion(Context context, GradleVersion cordovaVersion, Location location) {
        if (cordovaVersion.compareIgnoringQualifiers(VALID_CORDOVA_VERSION) < 0) {
            String message = String.format("You are using a vulnerable version of Cordova: %1$s", cordovaVersion.toString());
            context.report(ISSUE, location, message);
        }
    }

    @Override
    public void checkClass(ClassContext context, ClassNode classNode) {
        block5: {
            block4: {
                if (this.mCordovaVersion != null) {
                    return;
                }
                if (!classNode.name.equals(FQN_CORDOVA_DEVICE)) break block4;
                List methods = classNode.methods;
                block0: for (MethodNode method : methods) {
                    if (!"<clinit>".equals(method.name)) continue;
                    InsnList nodes = method.instructions;
                    int n = nodes.size();
                    for (int i = 0; i < n; ++i) {
                        AbstractInsnNode instruction = nodes.get(i);
                        int type = instruction.getType();
                        if (type != 4) continue;
                        this.checkInstructionInternal(context, classNode, instruction);
                        continue block0;
                    }
                }
                break block5;
            }
            if (!classNode.name.equals(FQN_CORDOVA_WEBVIEW)) break block5;
            List fields = classNode.fields;
            for (FieldNode node : fields) {
                if (!FIELD_NAME_CORDOVA_VERSION_WEBVIEW.equals(node.name) || (node.access & 0x10) != 16 || (node.access & 8) != 8 || !(node.value instanceof String)) continue;
                this.mCordovaVersion = CordovaVersionDetector.createVersion((String)node.value);
                if (this.mCordovaVersion == null) continue;
                CordovaVersionDetector.validateCordovaVersion(context, this.mCordovaVersion, context.getLocation(classNode));
            }
        }
    }

    private void checkInstructionInternal(ClassContext context, ClassNode classNode, AbstractInsnNode instruction) {
        FieldInsnNode node = (FieldInsnNode)instruction;
        if (node.getOpcode() == 179 && node.owner.equals(FQN_CORDOVA_DEVICE) && node.name.equals(FIELD_NAME_CORDOVA_VERSION)) {
            AbstractInsnNode prevInstruction = LintUtils.getPrevInstruction((AbstractInsnNode)node);
            if (prevInstruction == null || prevInstruction.getOpcode() != 18) {
                return;
            }
            LdcInsnNode ldcInsnNode = (LdcInsnNode)prevInstruction;
            if (ldcInsnNode.cst instanceof String) {
                this.mCordovaVersion = CordovaVersionDetector.createVersion((String)ldcInsnNode.cst);
                if (this.mCordovaVersion != null) {
                    CordovaVersionDetector.validateCordovaVersion(context, this.mCordovaVersion, context.getLocation(classNode));
                }
            }
        }
    }

    private static GradleVersion createVersion(String version) {
        Matcher matcher = VERSION_STR.matcher(version);
        if (matcher.matches()) {
            return GradleVersion.tryParse((String)matcher.group(1));
        }
        return null;
    }

    public static class JsVersionLineProcessor
    implements LineProcessor<GradleVersion> {
        private static final Pattern PATTERN = Pattern.compile("var\\s*(PLATFORM_VERSION_BUILD_LABEL|CORDOVA_JS_BUILD_LABEL)\\s*=\\s*'(\\d+\\.\\d+\\.\\d+)[^']*';.*");
        private GradleVersion mVersion;

        public boolean processLine(String line) throws IOException {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                this.mVersion = GradleVersion.tryParse((String)matcher.group(2));
                return false;
            }
            return true;
        }

        public GradleVersion getResult() {
            return this.mVersion;
        }
    }
}

