/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.parse.standard;

import com.springsource.util.osgi.manifest.parse.standard.HeaderProblemKind;
import com.springsource.util.osgi.manifest.parse.standard.Severity;
import com.springsource.util.osgi.manifest.parse.standard.SourceContext;

public class HeaderProblem {
    private HeaderProblemKind problemKind;
    private int startoffset;
    private int endoffset;
    private String[] inserts;

    public HeaderProblem(HeaderProblemKind problem, int startoffset, int endoffset, String ... inserts) {
        this.problemKind = problem;
        this.startoffset = startoffset;
        this.endoffset = endoffset;
        this.inserts = inserts;
    }

    public String toString(SourceContext context) {
        return this.problemKind.format(context.getLine(this.startoffset), context.getColumn(this.startoffset), this.inserts);
    }

    public String toStringWithContext(SourceContext context) {
        int relevantLine = context.getLine(this.startoffset);
        String relevantLineData = context.getLineAsString(relevantLine);
        String theMessage = this.toString(context);
        StringBuilder beautifulMessage = new StringBuilder();
        beautifulMessage.append(relevantLineData).append('\n');
        int scol = context.getColumn(this.startoffset);
        int ecol = context.getColumn(this.endoffset);
        int where = 0;
        where = 0;
        while (where < scol) {
            beautifulMessage.append(' ');
            ++where;
        }
        beautifulMessage.append('^');
        if (ecol != scol) {
            ++where;
            while (where < ecol) {
                beautifulMessage.append(' ');
                ++where;
            }
            beautifulMessage.append('^');
        }
        beautifulMessage.append('\n');
        beautifulMessage.append(theMessage);
        return beautifulMessage.toString();
    }

    public String toString() {
        return this.problemKind.format(0, 0, this.inserts);
    }

    public HeaderProblemKind getKind() {
        return this.problemKind;
    }

    public String[] getInserts() {
        String[] insertCopy = new String[this.inserts.length];
        System.arraycopy(this.inserts, 0, insertCopy, 0, this.inserts.length);
        return insertCopy;
    }

    public int getStartOffset() {
        return this.startoffset;
    }

    public int getEndOffset() {
        return this.endoffset;
    }

    public boolean isSeverity(Severity severity) {
        return this.problemKind.isSeverity(severity);
    }
}

