/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.internal;

import com.springsource.util.osgi.manifest.ImportedBundle;
import com.springsource.util.osgi.manifest.Sharing;
import com.springsource.util.osgi.manifest.internal.BaseImported;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import java.util.List;

class StandardImportedBundle
extends BaseImported
implements ImportedBundle {
    private static final String SHARING_SHARE = "share";
    private static final String SHARING_CLONE = "clone";
    private static final String SHARING_DIRECTIVE = "sharing";
    private static final String IMPORT_SCOPE_APPLICATION = "application";
    private static final String IMPORT_SCOPE_DIRECTIVE = "import-scope";

    public StandardImportedBundle(HeaderParser parser, String name) {
        super(parser, name);
    }

    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        List<HeaderDeclaration> header = parser.parseImportBundleHeader(parseString);
        return header.get(0);
    }

    public boolean isApplicationImportScope() {
        return IMPORT_SCOPE_APPLICATION.equals(this.getDirectives().get(IMPORT_SCOPE_DIRECTIVE));
    }

    public String getBundleSymbolicName() {
        return this.name;
    }

    public Sharing getSharing() {
        String value = this.getDirectives().get(SHARING_DIRECTIVE);
        if (SHARING_SHARE.equals(value)) {
            return Sharing.SHARE;
        }
        if (SHARING_CLONE.equals(value)) {
            return Sharing.CLONE;
        }
        return Sharing.AUTOMATIC;
    }

    public void setApplicationImportScope(boolean applicationImportScope) {
        if (applicationImportScope) {
            this.getDirectives().put(IMPORT_SCOPE_DIRECTIVE, IMPORT_SCOPE_APPLICATION);
        } else {
            this.getDirectives().remove(IMPORT_SCOPE_DIRECTIVE);
        }
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        if (bundleSymbolicName == null) {
            throw new IllegalArgumentException("bundleSymbolicName must not be null");
        }
        this.name = bundleSymbolicName;
    }

    public void setSharing(Sharing sharing) {
        if (sharing == null) {
            this.getDirectives().remove(SHARING_DIRECTIVE);
            return;
        }
        switch (sharing) {
            case CLONE: {
                this.getDirectives().put(SHARING_DIRECTIVE, SHARING_CLONE);
                break;
            }
            case SHARE: {
                this.getDirectives().put(SHARING_DIRECTIVE, SHARING_SHARE);
                break;
            }
            default: {
                this.getDirectives().remove(SHARING_DIRECTIVE);
            }
        }
    }
}

