/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.internal;

import com.springsource.util.common.CaseInsensitiveMap;
import com.springsource.util.osgi.manifest.BundleActivationPolicy;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.BundleSymbolicName;
import com.springsource.util.osgi.manifest.DynamicImportPackage;
import com.springsource.util.osgi.manifest.ExportPackage;
import com.springsource.util.osgi.manifest.FragmentHost;
import com.springsource.util.osgi.manifest.ImportBundle;
import com.springsource.util.osgi.manifest.ImportLibrary;
import com.springsource.util.osgi.manifest.ImportPackage;
import com.springsource.util.osgi.manifest.Parseable;
import com.springsource.util.osgi.manifest.RequireBundle;
import com.springsource.util.osgi.manifest.internal.HeaderUtils;
import com.springsource.util.osgi.manifest.internal.StandardBundleActivationPolicy;
import com.springsource.util.osgi.manifest.internal.StandardBundleSymbolicName;
import com.springsource.util.osgi.manifest.internal.StandardDynamicImportPackage;
import com.springsource.util.osgi.manifest.internal.StandardExportPackage;
import com.springsource.util.osgi.manifest.internal.StandardFragmentHost;
import com.springsource.util.osgi.manifest.internal.StandardImportBundle;
import com.springsource.util.osgi.manifest.internal.StandardImportLibrary;
import com.springsource.util.osgi.manifest.internal.StandardImportPackage;
import com.springsource.util.osgi.manifest.internal.StandardRequireBundle;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import com.springsource.util.osgi.manifest.parse.ParserLogger;
import com.springsource.util.osgi.manifest.parse.standard.StandardHeaderParser;
import com.springsource.util.parser.manifest.ManifestContents;
import com.springsource.util.parser.manifest.ManifestProblem;
import com.springsource.util.parser.manifest.ManifestProblemKind;
import com.springsource.util.parser.manifest.RecoveringManifestParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardBundleManifest
implements BundleManifest {
    private static final String MANIFEST_VERSION = "Manifest-Version";
    private final CaseInsensitiveMap<String> contents = new CaseInsensitiveMap();
    private final CaseInsensitiveMap<Parseable> headers;

    public StandardBundleManifest(ParserLogger logger) {
        this(logger, (Map<String, String>)new Hashtable<String, String>());
    }

    public StandardBundleManifest(ParserLogger logger, Map<String, String> contents) {
        this.contents.putAll(contents);
        this.headers = StandardBundleManifest.initializeHeaders(this.contents, new StandardHeaderParser(logger));
    }

    public StandardBundleManifest(ParserLogger logger, Dictionary<String, String> contents) {
        this(logger, StandardBundleManifest.dictionaryToMap(contents));
    }

    private static Map<String, String> dictionaryToMap(Dictionary<String, String> contents) {
        HashMap<String, String> map = new HashMap<String, String>(contents.size());
        Enumeration<String> keys = contents.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, contents.get(key));
        }
        return map;
    }

    public StandardBundleManifest(ParserLogger logger, Reader reader) throws IOException {
        this(logger, StandardBundleManifest.parseContents(reader));
    }

    public StandardBundleManifest(ParserLogger logger, ManifestContents manifestContents) {
        this(logger, manifestContents.getMainAttributes());
    }

    private static ManifestContents parseContents(Reader reader) throws IOException {
        RecoveringManifestParser parser = new RecoveringManifestParser();
        parser.setTerminateAfterMainSection(true);
        ManifestContents contents = parser.parse(reader);
        if (parser.foundProblems()) {
            List<ManifestProblem> problems = parser.getProblems();
            for (ManifestProblem problem : problems) {
                if (problem.getKind().equals((Object)ManifestProblemKind.ILLEGAL_NAME_CHAR) || problem.getKind().equals((Object)ManifestProblemKind.VALUE_TOO_LONG)) continue;
                throw new IOException(problems.toString());
            }
        }
        return contents;
    }

    private static CaseInsensitiveMap<Parseable> initializeHeaders(Map<String, String> contents, HeaderParser parser) {
        CaseInsensitiveMap<Parseable> headers = StandardBundleManifest.createHeadersMap(parser);
        for (Map.Entry<String, Parseable> entry : headers.entrySet()) {
            String value = contents.get(entry.getKey());
            if (value == null) continue;
            entry.getValue().resetFromParseString(value);
        }
        return headers;
    }

    private static CaseInsensitiveMap<Parseable> createHeadersMap(HeaderParser parser) {
        CaseInsensitiveMap<Parseable> headers = new CaseInsensitiveMap<Parseable>();
        headers.put("Bundle-ActivationPolicy", (Parseable)new StandardBundleActivationPolicy(parser));
        headers.put("Bundle-SymbolicName", (Parseable)new StandardBundleSymbolicName(parser));
        headers.put("DynamicImport-Package", (Parseable)new StandardDynamicImportPackage(parser));
        headers.put("Export-Package", (Parseable)new StandardExportPackage(parser));
        headers.put("Fragment-Host", (Parseable)new StandardFragmentHost(parser));
        headers.put("Import-Bundle", (Parseable)new StandardImportBundle(parser));
        headers.put("Import-Library", (Parseable)new StandardImportLibrary(parser));
        headers.put("Import-Package", (Parseable)new StandardImportPackage(parser));
        headers.put("Require-Bundle", (Parseable)new StandardRequireBundle(parser));
        return headers;
    }

    @Override
    public BundleActivationPolicy getBundleActivationPolicy() {
        return (BundleActivationPolicy)this.headers.get("Bundle-ActivationPolicy");
    }

    @Override
    public List<String> getBundleClasspath() {
        return HeaderUtils.toList("Bundle-ClassPath", this.contents);
    }

    @Override
    public String getBundleDescription() {
        return this.contents.get("Bundle-Description");
    }

    @Override
    public int getBundleManifestVersion() {
        int bundleManifestVersion = 1;
        String value = this.contents.get("Bundle-ManifestVersion");
        if (value != null) {
            bundleManifestVersion = Integer.parseInt(value);
        }
        return bundleManifestVersion;
    }

    @Override
    public String getBundleName() {
        return this.contents.get("Bundle-Name");
    }

    @Override
    public BundleSymbolicName getBundleSymbolicName() {
        return (BundleSymbolicName)this.headers.get("Bundle-SymbolicName");
    }

    @Override
    public URL getBundleUpdateLocation() {
        URL updateLocation = null;
        String value = this.contents.get("Bundle-UpdateLocation");
        if (value != null) {
            try {
                updateLocation = new URL(value);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return updateLocation;
    }

    @Override
    public DynamicImportPackage getDynamicImportPackage() {
        return (DynamicImportPackage)this.headers.get("DynamicImport-Package");
    }

    @Override
    public ExportPackage getExportPackage() {
        return (ExportPackage)this.headers.get("Export-Package");
    }

    @Override
    public FragmentHost getFragmentHost() {
        return (FragmentHost)this.headers.get("Fragment-Host");
    }

    @Override
    public ImportBundle getImportBundle() {
        return (ImportBundle)this.headers.get("Import-Bundle");
    }

    @Override
    public ImportLibrary getImportLibrary() {
        return (ImportLibrary)this.headers.get("Import-Library");
    }

    @Override
    public ImportPackage getImportPackage() {
        return (ImportPackage)this.headers.get("Import-Package");
    }

    @Override
    public String getModuleScope() {
        return this.contents.get("Module-Scope");
    }

    @Override
    public String getModuleType() {
        return this.contents.get("Module-Type");
    }

    @Override
    public RequireBundle getRequireBundle() {
        return (RequireBundle)this.headers.get("Require-Bundle");
    }

    @Override
    public void setBundleDescription(String bundleDescription) {
        if (bundleDescription == null) {
            this.contents.remove("Bundle-Description");
        } else {
            this.contents.put("Bundle-Description", bundleDescription);
        }
    }

    @Override
    public void setBundleManifestVersion(int bundleManifestVersion) {
        this.contents.put("Bundle-ManifestVersion", Integer.toString(bundleManifestVersion));
    }

    @Override
    public void setBundleName(String bundleName) {
        if (bundleName == null) {
            this.contents.remove("Bundle-Name");
        } else {
            this.contents.put("Bundle-Name", bundleName);
        }
    }

    @Override
    public void setBundleUpdateLocation(URL bundleUpdateLocation) {
        if (bundleUpdateLocation == null) {
            this.contents.remove("Bundle-UpdateLocation");
        } else {
            this.contents.put("Bundle-UpdateLocation", bundleUpdateLocation.toExternalForm());
        }
    }

    @Override
    public void setModuleScope(String moduleScope) {
        if (moduleScope == null) {
            this.contents.remove("Module-Scope");
        } else {
            this.contents.put("Module-Scope", moduleScope);
        }
    }

    @Override
    public void setModuleType(String moduleType) {
        if (moduleType == null) {
            this.contents.remove("Module-Type");
        } else {
            this.contents.put("Module-Type", moduleType);
        }
    }

    @Override
    public Dictionary<String, String> toDictionary() {
        this.synchroniseContentsWithHeaders();
        Hashtable<String, String> output = new Hashtable<String, String>();
        output.putAll(this.contents);
        return output;
    }

    @Override
    public Version getBundleVersion() {
        String value = this.contents.get("Bundle-Version");
        if (value != null) {
            return new Version(value);
        }
        return Version.emptyVersion;
    }

    @Override
    public void setBundleVersion(Version bundleVersion) {
        if (bundleVersion != null) {
            this.contents.put("Bundle-Version", bundleVersion.toString());
        } else {
            this.contents.remove("Bundle-Version");
        }
    }

    @Override
    public String getHeader(String name) {
        this.synchroniseContentsWithHeaders();
        return this.contents.get(name);
    }

    private void synchroniseContentsWithHeaders() {
        for (Map.Entry<String, String> entry : this.contents.entrySet()) {
            Parseable header = this.headers.get(entry.getKey());
            if (header == null) continue;
            String headerValue = header.toParseString();
            if (headerValue != null) {
                this.contents.put(entry.getKey(), headerValue);
                continue;
            }
            this.contents.remove(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            String headerValue;
            if (this.contents.get(entry.getKey()) != null || (headerValue = ((Parseable)entry.getValue()).toParseString()) == null) continue;
            this.contents.put(entry.getKey(), headerValue);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (value == null) {
            this.contents.remove(name);
        } else {
            this.contents.put(name, value);
        }
        Parseable header = this.headers.get(name);
        if (header != null) {
            header.resetFromParseString(value);
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        Dictionary<String, String> dictionary = this.toDictionary();
        if (dictionary.get(MANIFEST_VERSION) == null) {
            dictionary.put(MANIFEST_VERSION, "1.0");
        }
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            attributes.putValue(key, dictionary.get(key));
        }
        WriterOutputStream writerOutputStream = new WriterOutputStream(writer);
        try {
            manifest.write(writerOutputStream);
        }
        finally {
            ((OutputStream)writerOutputStream).close();
        }
    }

    public String toString() {
        StringWriter outputManifest = new StringWriter();
        try {
            this.write(outputManifest);
        }
        catch (Exception exception) {}
        return outputManifest.toString();
    }

    public static class WriterOutputStream
    extends OutputStream {
        private final Writer writer;

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        public void write(int b) throws IOException {
            this.writer.write(b);
        }

        public void close() throws IOException {
            this.writer.close();
        }
    }
}

