/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.internal;

import com.springsource.util.osgi.VersionRange;
import com.springsource.util.osgi.manifest.Imported;
import com.springsource.util.osgi.manifest.Resolution;
import com.springsource.util.osgi.manifest.internal.BaseCompoundHeaderEntry;
import com.springsource.util.osgi.manifest.parse.HeaderParser;

abstract class BaseImported
extends BaseCompoundHeaderEntry
implements Imported {
    BaseImported(HeaderParser parser, String name) {
        super(parser, name);
    }

    public Resolution getResolution() {
        String value = this.getDirectives().get("resolution");
        if ("optional".equals(value)) {
            return Resolution.OPTIONAL;
        }
        return Resolution.MANDATORY;
    }

    public VersionRange getVersion() {
        String value = this.getAttributes().get("version");
        return new VersionRange(value);
    }

    public void setResolution(Resolution resolution) {
        if (resolution == null) {
            this.getDirectives().remove("resolution");
            return;
        }
        switch (resolution) {
            case OPTIONAL: {
                this.getDirectives().put("resolution", "optional");
                break;
            }
            default: {
                this.getDirectives().remove("resolution");
            }
        }
    }

    public void setVersion(VersionRange versionRange) {
        if (versionRange != null) {
            this.getAttributes().put("version", versionRange.toParseString());
        } else {
            this.getAttributes().remove("version");
        }
    }
}

