/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.propertysubstitution;

import com.springsource.bundlor.support.propertysubstitution.Transformer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VersionExpander {
    private final boolean startInclusive;
    private final List<Transformer> lower;
    private final List<Transformer> upper;
    private final boolean endInclusive;

    public VersionExpander(boolean startInclusive, List<Transformer> lower, List<Transformer> upper, boolean endInclusive) {
        this.startInclusive = startInclusive;
        this.lower = lower;
        this.upper = upper;
        this.endInclusive = endInclusive;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.startInclusive ? "[" : "(");
        int pos = 0;
        for (Transformer t : this.lower) {
            if (pos > 0) {
                sb.append(".");
            }
            sb.append(t);
            ++pos;
        }
        sb.append(",");
        pos = 0;
        for (Transformer t : this.upper) {
            if (pos > 0) {
                sb.append(".");
            }
            sb.append(t);
            ++pos;
        }
        sb.append(this.endInclusive ? "]" : ")");
        return sb.toString();
    }

    public String expand(int maj, int min, int mic, String qualifier) {
        StringBuffer expansion = new StringBuffer();
        expansion.append(this.startInclusive ? "[" : "(");
        expansion.append(this.lower.get(0).transform(maj));
        if (this.lower.size() > 1) {
            expansion.append(".");
            expansion.append(this.lower.get(1).transform(min));
            if (this.lower.size() > 2) {
                expansion.append(".");
                expansion.append(this.lower.get(2).transform(mic));
                if (this.lower.size() > 3) {
                    expansion.append(".");
                    expansion.append(this.lower.get(3).transform(qualifier));
                }
            }
        }
        expansion.append(",");
        expansion.append(this.upper.get(0).transform(maj));
        if (this.upper.size() > 1) {
            expansion.append(".");
            expansion.append(this.upper.get(1).transform(min));
            if (this.upper.size() > 2) {
                expansion.append(".");
                expansion.append(this.upper.get(2).transform(mic));
                if (this.upper.size() > 3) {
                    expansion.append(".");
                    expansion.append(this.upper.get(3).transform(qualifier));
                }
            }
        }
        expansion.append(this.endInclusive ? "]" : ")");
        return expansion.toString();
    }
}

