/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.propertysubstitution;

import com.springsource.bundlor.support.ManifestModifier;
import com.springsource.bundlor.support.ManifestTemplateModifier;
import com.springsource.bundlor.support.TemplateHeaderReader;
import com.springsource.bundlor.support.propertysubstitution.VersionExpansionTransformer;
import com.springsource.util.common.PropertyPlaceholderResolver;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaceholderManifestAndTemplateModifier
implements ManifestModifier,
ManifestTemplateModifier,
TemplateHeaderReader {
    private final Properties properties;

    public PlaceholderManifestAndTemplateModifier(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void modify(ManifestContents manifest) {
        VersionExpansionTransformer transformer = new VersionExpansionTransformer(manifest);
        PropertyPlaceholderResolver placeholderResolver = new PropertyPlaceholderResolver();
        for (Map.Entry<String, String> entry : manifest.getMainAttributes().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            manifest.getMainAttributes().put(key, placeholderResolver.resolve(value, this.properties, transformer));
        }
        for (String name : manifest.getSectionNames()) {
            for (Map.Entry<String, String> entry : manifest.getAttributesForSection(name).entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                manifest.getAttributesForSection(name).put(key, placeholderResolver.resolve(value, this.properties, transformer));
            }
        }
    }

    @Override
    public List<String> getTemplateOnlyHeaderNames() {
        return new VersionExpansionTransformer().getTemplateOnlyHeaderNames();
    }
}

