/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.asm;

import com.springsource.bundlor.support.asm.VisitorUtils;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

final class ArtefactAnalyserMethodVisitor
extends EmptyVisitor
implements MethodVisitor {
    private final PartialManifest partialManifest;
    private final Type type;

    public ArtefactAnalyserMethodVisitor(PartialManifest partialManifest, Type type) {
        this.partialManifest = partialManifest;
        this.type = type;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Type t = Type.getType(desc);
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
        VisitorUtils.recordUses(this.partialManifest, this.type, t);
        return null;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getType(desc));
        VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getObjectType(owner));
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        Type t = Type.getType(desc);
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Type t = Type.getObjectType(owner);
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
        VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getReturnType(desc));
        VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getArgumentTypes(desc));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        Type t = Type.getType(desc);
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        Type t = Type.getType(desc);
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
        VisitorUtils.recordUses(this.partialManifest, this.type, t);
        return null;
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            Type t = Type.getObjectType(type);
            VisitorUtils.recordReferencedTypes(this.partialManifest, t);
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        Type t = Type.getObjectType(type);
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            VisitorUtils.recordReferencedTypes(this.partialManifest, (Type)cst);
        }
    }
}

