/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.parser.StylusParser;
import org.jetbrains.plugins.stylus.psi.StylusVariableDeclaration;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;

public class StylusUtil {
    private static final int VARIABLE_PRIORITY = 8;
    private static final int MIXIN_PRIORITY = 5;
    private static final int IMPORTED_ELEMENT_PRIORITY = 1;
    private static final int KEYWORD_ELEMENT_PRIORITY = 10;

    public static boolean isOperationToken(IElementType tokenType) {
        if (tokenType == null) {
            return false;
        }
        for (TokenSet t : StylusParser.OPERATOR_PRIORITY) {
            if (!t.contains(tokenType)) continue;
            return true;
        }
        TokenSet otherOperators = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_EQ});
        return otherOperators.contains(tokenType);
    }

    @NotNull
    public static LookupElement createMixinLookupItem(StylusMixinImpl mixin, boolean validResult) {
        ItemPresentation itemPresentation = mixin.getPresentation();
        int priority = validResult ? 6 : 5;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)mixin.getName(), (PsiElement)mixin).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS).withTypeText(itemPresentation.getLocationString(), true), (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/StylusUtil", "createMixinLookupItem"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createVariableLookupItem(StylusVariableDeclaration declaration, boolean validResult) {
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? "" : " implicitly imported";
        int priority = validResult ? 9 : 8;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declaration.getName(), (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/StylusUtil", "createVariableLookupItem"));
        }
        return lookupElement;
    }

    public static LookupElement createKeywordLookupItem(String keyword, @Nullable InsertHandler<LookupElement> insertHandler) {
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)keyword).bold().withInsertHandler(insertHandler), (double)10.0);
    }
}

