/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServletMappingInfo {
    private final String myUrlPattern;
    private final CommonServletMapping<CommonServlet> myServletMapping;
    private final ServletMappingType myType;

    public static List<ServletMappingInfo> createMappingInfos(CommonServletMapping mapping) {
        List<GenericValue<String>> patterns = mapping.getUrlPatterns();
        if (patterns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ServletMappingInfo> infos = new ArrayList<ServletMappingInfo>(patterns.size());
        for (GenericValue<String> pattern : patterns) {
            String s = pattern.getStringValue();
            if (s == null) continue;
            ServletMappingInfo mappingInfo = ServletMappingType.getPatternType(s).createMappingInfo(s, mapping);
            infos.add(mappingInfo);
        }
        return infos;
    }

    protected ServletMappingInfo(@NotNull String urlPattern, CommonServletMapping<CommonServlet> mapping, ServletMappingType type) {
        if (urlPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlPattern", "com/intellij/javaee/web/ServletMappingInfo", "<init>"));
        }
        this.myUrlPattern = urlPattern;
        this.myServletMapping = mapping;
        this.myType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServletMappingInfo info = (ServletMappingInfo)o;
        if (!this.myServletMapping.equals(info.myServletMapping)) {
            return false;
        }
        if (this.myType != info.myType) {
            return false;
        }
        return this.myUrlPattern.equals(info.myUrlPattern);
    }

    public int hashCode() {
        int result = this.myUrlPattern.hashCode();
        result = 31 * result + this.myServletMapping.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    @NotNull
    public final CommonServletMapping getServletMapping() {
        CommonServletMapping<CommonServlet> commonServletMapping = this.myServletMapping;
        if (commonServletMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingInfo", "getServletMapping"));
        }
        return commonServletMapping;
    }

    public CommonServlet getServlet() {
        return this.myServletMapping.getServlet();
    }

    @NotNull
    public final String getUrlPattern() {
        String string = this.myUrlPattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingInfo", "getUrlPattern"));
        }
        return string;
    }

    @NotNull
    public final ServletMappingType getType() {
        ServletMappingType servletMappingType = this.myType;
        if (servletMappingType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingInfo", "getType"));
        }
        return servletMappingType;
    }

    @Nullable
    public abstract TextRange getNameRange(String var1);

    @Nullable
    public abstract TextRange getMappingRange(String var1);

    public abstract String stripMapping(@NotNull String var1);

    public abstract String addMapping(@NotNull String var1);

    public boolean matches(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo", "matches"));
        }
        return this.getMappingRange(url) != null;
    }

    @Nullable
    public PsiReference getMappingReference(PsiElement element, String actionUrl, boolean soft) {
        TextRange range = this.getMappingRange(actionUrl);
        if (range == null) {
            return null;
        }
        PsiReferenceBase<PsiElement> ref = new PsiReferenceBase<PsiElement>(element, range, soft){

            @Nullable
            public PsiElement resolve() {
                assert (ServletMappingInfo.this.myServletMapping != null);
                return ServletMappingInfo.this.myServletMapping.getMappingElement();
            }

            @NotNull
            public Object[] getVariants() {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/ServletMappingInfo$1", "getVariants"));
                }
                return EMPTY_ARRAY;
            }
        };
        TextRange textRange = range.shiftRight(ref.getRangeInElement().getStartOffset());
        ref.setRangeInElement(textRange);
        return ref;
    }

    public static class DefaultMappingInfo
    extends ServletMappingInfo {
        public DefaultMappingInfo(String urlPattern, CommonServletMapping mapping) {
            super(urlPattern, mapping, ServletMappingType.DEFAULT);
        }

        @Override
        @Nullable
        public TextRange getNameRange(String url) {
            return null;
        }

        @Override
        @Nullable
        public TextRange getMappingRange(String url) {
            return url.equals("/") ? TextRange.from((int)0, (int)1) : null;
        }

        @Override
        public String stripMapping(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo$DefaultMappingInfo", "stripMapping"));
            }
            return url;
        }

        @Override
        public String addMapping(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo$DefaultMappingInfo", "addMapping"));
            }
            return url;
        }
    }

    public static class ExactMappingInfo
    extends ServletMappingInfo {
        public ExactMappingInfo(String urlPattern, CommonServletMapping mapping) {
            super(urlPattern, mapping, ServletMappingType.EXACT);
        }

        @Override
        @Nullable
        public TextRange getNameRange(String url) {
            return WebUtil.trimRange(url, new TextRange(0, url.length()));
        }

        @Override
        @Nullable
        public TextRange getMappingRange(String url) {
            return null;
        }

        @Override
        @Nullable
        public String stripMapping(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo$ExactMappingInfo", "stripMapping"));
            }
            return url;
        }

        @Override
        public String addMapping(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo$ExactMappingInfo", "addMapping"));
            }
            return url;
        }
    }

    public static class PathMappingInfo
    extends ServletMappingInfo {
        private final String myMappingSubstring;

        public PathMappingInfo(String urlPattern, CommonServletMapping mapping) {
            super(urlPattern, mapping, ServletMappingType.PATH);
            this.myMappingSubstring = urlPattern.substring(0, urlPattern.length() - 2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PathMappingInfo that = (PathMappingInfo)o;
            return this.myMappingSubstring.equals(that.myMappingSubstring);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myMappingSubstring.hashCode();
            return result;
        }

        @Override
        @Nullable
        public TextRange getNameRange(String url) {
            int pos = url.indexOf(this.myMappingSubstring.isEmpty() ? "/" : this.myMappingSubstring);
            if (pos == 0 && url.length() > this.myMappingSubstring.length()) {
                return new TextRange(this.myMappingSubstring.length() + 1, url.length());
            }
            return null;
        }

        @Override
        @Nullable
        public TextRange getMappingRange(String url) {
            int pos = url.indexOf(this.myMappingSubstring);
            if (pos == 0) {
                return new TextRange(0, this.myMappingSubstring.length());
            }
            return null;
        }

        @Override
        @Nullable
        public String stripMapping(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo$PathMappingInfo", "stripMapping"));
            }
            int pos = url.indexOf(this.myMappingSubstring);
            if (pos == 0) {
                return url.substring(this.myMappingSubstring.length());
            }
            return null;
        }

        @Override
        public String addMapping(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo$PathMappingInfo", "addMapping"));
            }
            return this.myMappingSubstring + url;
        }
    }

    public static class ExtensionMappingInfo
    extends ServletMappingInfo {
        private final String mySubstring;

        public ExtensionMappingInfo(String urlPattern, CommonServletMapping mapping) {
            super(urlPattern, mapping, ServletMappingType.EXTENSION);
            this.mySubstring = urlPattern.substring(1);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtensionMappingInfo that = (ExtensionMappingInfo)o;
            return this.mySubstring.equals(that.mySubstring);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.mySubstring.hashCode();
            return result;
        }

        @Override
        @Nullable
        public TextRange getNameRange(String url) {
            int pos = url.indexOf(this.mySubstring);
            if (pos != -1 && pos == url.length() - this.mySubstring.length()) {
                return new TextRange(0, pos);
            }
            return null;
        }

        @Override
        @Nullable
        public TextRange getMappingRange(String actionUrl) {
            int pos = actionUrl.indexOf(this.mySubstring);
            if (pos != -1 && pos == actionUrl.length() - this.mySubstring.length()) {
                return new TextRange(pos + 1, actionUrl.length());
            }
            return null;
        }

        @Override
        @Nullable
        public String stripMapping(@NotNull String actionUrl) {
            if (actionUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionUrl", "com/intellij/javaee/web/ServletMappingInfo$ExtensionMappingInfo", "stripMapping"));
            }
            int pos = actionUrl.indexOf(this.mySubstring);
            if (pos != -1 && pos == actionUrl.length() - this.mySubstring.length()) {
                return actionUrl.substring(0, pos);
            }
            return actionUrl;
        }

        @Override
        public String addMapping(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/ServletMappingInfo$ExtensionMappingInfo", "addMapping"));
            }
            return url + this.mySubstring;
        }
    }
}

