/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.BasicDomElementComponent;
import com.intellij.util.xml.ui.CommittablePanel;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;

public class AbstractCommittableTab<T extends DomElement>
extends BasicDomElementComponent<T> {
    private final String myName;
    private boolean mySelected;
    private CommittablePanel myPanel;
    private final Set<Document> myDocuments = new HashSet<Document>();
    private final PsiDocumentManager myManager;
    private final DocumentListener myDocumentListener = new DocumentAdapter(){

        public void documentChanged(DocumentEvent e) {
            for (Document document : AbstractCommittableTab.this.myDocuments) {
                AbstractCommittableTab.this.myManager.commitDocument(document);
            }
            AbstractCommittableTab.this.getPanel().reset();
        }
    };

    public AbstractCommittableTab(String name, T element) {
        super(element);
        this.myName = name;
        this.myManager = PsiDocumentManager.getInstance((Project)element.getManager().getProject());
        ContainerUtil.addAll(this.myDocuments, (Object[])new Document[]{this.myManager.getDocument((PsiFile)DomUtil.getFile(element))});
    }

    public AbstractCommittableTab(String name, CommittablePanel panel, Project project) {
        super(null);
        this.myName = name;
        this.myPanel = panel;
        this.myManager = PsiDocumentManager.getInstance((Project)project);
    }

    protected AbstractCommittableTab(String name, CommittablePanel panel, PsiFile file) {
        this(name, panel, PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file), file.getProject());
    }

    protected AbstractCommittableTab(String name, CommittablePanel panel, Document document, Project project) {
        super(null);
        this.myName = name;
        this.myPanel = panel;
        ContainerUtil.addAll(this.myDocuments, (Object[])new Document[]{document});
        this.myManager = PsiDocumentManager.getInstance((Project)project);
    }

    public final String getTabName() {
        return this.myName;
    }

    public final Set<Document> getWatchedDocuments() {
        return this.myDocuments;
    }

    public final void addWatchedElement(DomElement domElement) {
        this.addWatchedDocument(this.myManager.getDocument((PsiFile)DomUtil.getFile((DomElement)domElement)));
    }

    public final void removeWatchedElement(DomElement domElement) {
        this.removeWatchedDocument(this.myManager.getDocument((PsiFile)DomUtil.getFile((DomElement)domElement)));
    }

    public final void addWatchedDocument(Document document) {
        this.stopWatching();
        this.myDocuments.add(document);
        this.startWatching();
    }

    public final void removeWatchedDocument(Document document) {
        this.stopWatching();
        this.myDocuments.remove(document);
        this.startWatching();
    }

    public Icon getTabIcon() {
        return null;
    }

    public CommittablePanel getPanel() {
        return this.myPanel;
    }

    public void selectNotify() {
        if (this.mySelected) {
            return;
        }
        this.mySelected = true;
        this.startWatching();
        this.getPanel().reset();
    }

    private void startWatching() {
        if (this.mySelected) {
            for (Document document : this.myDocuments) {
                document.addDocumentListener(this.myDocumentListener);
            }
        }
    }

    public final void deselectNotify() {
        if (!this.mySelected) {
            return;
        }
        this.stopWatching();
        this.mySelected = false;
        ApplicationManager.getApplication().invokeLater(() -> this.getPanel().commit());
    }

    private void stopWatching() {
        if (this.mySelected) {
            for (Document document : this.myDocuments) {
                document.removeDocumentListener(this.myDocumentListener);
            }
        }
    }

    public JComponent getComponent() {
        return this.getPanel().getComponent();
    }
}

