/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.javaee.J2EEBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CapitalizedBooleanConverter
extends ResolvingConverter<Boolean> {
    public Boolean fromString(String s, ConvertContext context) {
        Pair<String, String> strings = this.getRequiredValues(context);
        return ((String)strings.first).equals(s) ? Boolean.TRUE : (((String)strings.second).equals(s) ? Boolean.FALSE : null);
    }

    protected abstract Pair<String, String> getRequiredValues(ConvertContext var1);

    public String toString(Boolean aBoolean, ConvertContext context) {
        Pair<String, String> strings = this.getRequiredValues(context);
        return aBoolean != false ? (String)strings.first : (String)strings.second;
    }

    public String getErrorMessage(String s, ConvertContext context) {
        Pair<String, String> strings = this.getRequiredValues(context);
        return J2EEBundle.message("value.should.either.0.or.1", strings.first, strings.second);
    }

    @NotNull
    public Collection<? extends Boolean> getVariants(ConvertContext context) {
        List<Boolean> list = Arrays.asList(Boolean.TRUE, Boolean.FALSE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/CapitalizedBooleanConverter", "getVariants"));
        }
        return list;
    }
}

