/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentModel
implements JDOMExternalizable,
Cloneable {
    @NonNls
    private static final String DEPLOYMENT_METHOD_NAME = "DEPLOYMENT_METHOD";
    @NonNls
    public static final String DEPLOYMENT_SOURCE_NAME = "DEPLOYMENT_SOURCE_NAME";
    private DeploymentMethod myDeploymentMethod;
    private CommonModel myParentConfiguration;
    private final DeploymentMethod[] myDeploymentMethods;
    private final DeploymentSource myDeploymentSource;

    protected DeploymentModel(@NotNull CommonModel parentConfiguration, ArtifactPointer artifactPointer) {
        if (parentConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentConfiguration", "com/intellij/javaee/deployment/DeploymentModel", "<init>"));
        }
        this(parentConfiguration, JavaeeDeploymentUtil.getInstance().createArtifactDeploymentSource(artifactPointer));
    }

    protected DeploymentModel(CommonModel parentConfiguration, DeploymentSource deploymentSource) {
        DeploymentMethod[] availableMethods;
        this.myDeploymentMethod = null;
        this.myParentConfiguration = parentConfiguration;
        DeploymentMethod[] deploymentMethods = DeploymentMethod.EMPTY_ARRAY;
        DeploymentProvider deploymentProvider = this.myParentConfiguration.getIntegration().getDeploymentProvider(parentConfiguration.isLocal());
        if (deploymentProvider == null) {
            deploymentProvider = this.myParentConfiguration.getServerModel().getDeploymentProvider();
        }
        if (deploymentProvider != null && (availableMethods = deploymentProvider.getAvailableMethods()) != null) {
            deploymentMethods = availableMethods;
        }
        this.myDeploymentMethods = deploymentMethods;
        this.myDeploymentSource = deploymentSource;
    }

    @NotNull
    public final DeploymentMethod[] getAvailableMethods() {
        if (this.myDeploymentMethods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/DeploymentModel", "getAvailableMethods"));
        }
        return this.myDeploymentMethods;
    }

    @Nullable
    public Artifact getArtifact() {
        return this.myDeploymentSource instanceof ArtifactDeploymentSource ? ((ArtifactDeploymentSource)this.myDeploymentSource).getArtifact() : null;
    }

    @Nullable
    public ArtifactPointer getArtifactPointer() {
        return this.myDeploymentSource instanceof ArtifactDeploymentSource ? ((ArtifactDeploymentSource)this.myDeploymentSource).getArtifactPointer() : null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        String methodName = element.getAttributeValue(DEPLOYMENT_METHOD_NAME);
        if (methodName != null) {
            this.setDeploymentMethod(this.findMethodByName(methodName));
        }
    }

    @Nullable
    private DeploymentMethod findMethodByName(String deplMethodName) {
        DeploymentMethod found = null;
        for (DeploymentMethod availableMethod : this.myDeploymentMethods) {
            if (!Comparing.equal((String)availableMethod.getName(), (String)deplMethodName)) continue;
            found = availableMethod;
        }
        return found;
    }

    public boolean shouldRedeployOnDeploymentSourceContentChange() {
        return false;
    }

    public boolean isValid() {
        return this.myDeploymentSource.isValid();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DeploymentMethod deploymentMethod = this.getDeploymentMethod();
        if (deploymentMethod != null) {
            element.setAttribute(DEPLOYMENT_METHOD_NAME, deploymentMethod.getName());
        }
    }

    @Nullable
    public DeploymentMethod getDeploymentMethod() {
        if (this.myDeploymentMethod == null) {
            for (DeploymentMethod method : this.myDeploymentMethods) {
                if (!method.isApplicable(this.myParentConfiguration)) continue;
                this.myDeploymentMethod = method;
                break;
            }
        }
        return this.myDeploymentMethod;
    }

    public void setDeploymentMethod(DeploymentMethod deploymentMethod) {
        this.myDeploymentMethod = deploymentMethod;
    }

    @NotNull
    public DeploymentSource getDeploymentSource() {
        DeploymentSource deploymentSource = this.myDeploymentSource;
        if (deploymentSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/DeploymentModel", "getDeploymentSource"));
        }
        return deploymentSource;
    }

    public CommonModel getCommonModel() {
        return this.myParentConfiguration;
    }

    public ServerModel getServerModel() {
        return this.myParentConfiguration.getServerModel();
    }
}

