/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe;

import com.android.tools.pixelprobe.effect.Shadow;
import com.android.tools.pixelprobe.util.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Effects {
    private final List<Shadow> outerShadows;
    private final List<Shadow> innerShadows;

    Effects(Builder builder) {
        this.outerShadows = Lists.immutableCopy(builder.outerShadows);
        this.innerShadows = Lists.immutableCopy(builder.innerShadows);
    }

    public List<Shadow> getOuterShadows() {
        return Collections.unmodifiableList(this.outerShadows);
    }

    public List<Shadow> getInnerShadows() {
        return Collections.unmodifiableList(this.innerShadows);
    }

    public static final class Builder {
        List<Shadow> outerShadows = new ArrayList<Shadow>();
        List<Shadow> innerShadows = new ArrayList<Shadow>();

        public Builder addShadow(Shadow shadow) {
            List<Shadow> list;
            boolean isInner = shadow.getType() == Shadow.Type.INNER;
            List<Shadow> list2 = list = isInner ? this.innerShadows : this.outerShadows;
            if (list.size() == 0) {
                list = new ArrayList<Shadow>();
                if (isInner) {
                    this.innerShadows = list;
                } else {
                    this.outerShadows = list;
                }
            }
            list.add(shadow);
            return this;
        }

        public Effects build() {
            return new Effects(this);
        }
    }
}

