/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.util.stream.Stream;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.MutableTestExecutionSummary;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(value=API.Usage.Experimental)
public class SummaryGeneratingListener
implements TestExecutionListener {
    private TestPlan testPlan;
    private MutableTestExecutionSummary summary;

    public TestExecutionSummary getSummary() {
        return this.summary;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.summary = new MutableTestExecutionSummary(testPlan);
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.summary.timeFinished = System.currentTimeMillis();
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        if (testIdentifier.isContainer()) {
            this.summary.containersFound.incrementAndGet();
        }
        if (testIdentifier.isTest()) {
            this.summary.testsFound.incrementAndGet();
        }
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        long skippedContainers = Stream.concat(Stream.of(testIdentifier), this.testPlan.getDescendants(testIdentifier).stream()).filter(TestIdentifier::isContainer).count();
        long skippedTests = Stream.concat(Stream.of(testIdentifier), this.testPlan.getDescendants(testIdentifier).stream()).filter(TestIdentifier::isTest).count();
        this.summary.containersSkipped.addAndGet(skippedContainers);
        this.summary.testsSkipped.addAndGet(skippedTests);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isContainer()) {
            this.summary.containersStarted.incrementAndGet();
        }
        if (testIdentifier.isTest()) {
            this.summary.testsStarted.incrementAndGet();
        }
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case SUCCESSFUL: {
                if (testIdentifier.isContainer()) {
                    this.summary.containersSucceeded.incrementAndGet();
                }
                if (!testIdentifier.isTest()) break;
                this.summary.testsSucceeded.incrementAndGet();
                break;
            }
            case ABORTED: {
                if (testIdentifier.isContainer()) {
                    this.summary.containersAborted.incrementAndGet();
                }
                if (!testIdentifier.isTest()) break;
                this.summary.testsAborted.incrementAndGet();
                break;
            }
            case FAILED: {
                if (testIdentifier.isContainer()) {
                    this.summary.containersFailed.incrementAndGet();
                }
                if (testIdentifier.isTest()) {
                    this.summary.testsFailed.incrementAndGet();
                }
                testExecutionResult.getThrowable().ifPresent(throwable -> this.summary.addFailure(testIdentifier, (Throwable)throwable));
                break;
            }
            default: {
                throw new PreconditionViolationException("Unsupported execution status:" + testExecutionResult.getStatus());
            }
        }
    }
}

