/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;

@API(value=API.Usage.Experimental)
public final class TestIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String uniqueId;
    private final String parentId;
    private final String displayName;
    private final TestSource source;
    private final Set<TestTag> tags;
    private final boolean test;
    private final boolean container;

    @API(value=API.Usage.Internal)
    public static TestIdentifier from(TestDescriptor testDescriptor) {
        Preconditions.notNull((Object)testDescriptor, (String)"TestDescriptor must not be null");
        String uniqueId = testDescriptor.getUniqueId().toString();
        String displayName = testDescriptor.getDisplayName();
        Optional source = testDescriptor.getSource();
        Set tags = testDescriptor.getTags();
        boolean test = testDescriptor.isTest();
        boolean container = !test || !testDescriptor.getChildren().isEmpty();
        Optional<String> parentId = testDescriptor.getParent().map(parentDescriptor -> parentDescriptor.getUniqueId().toString());
        return new TestIdentifier(uniqueId, displayName, source, tags, test, container, parentId);
    }

    TestIdentifier(String uniqueId, String displayName, Optional<TestSource> source, Set<TestTag> tags, boolean test, boolean container, Optional<String> parentId) {
        this.uniqueId = uniqueId;
        this.parentId = parentId.orElse(null);
        this.displayName = displayName;
        this.source = source.orElse(null);
        this.tags = Collections.unmodifiableSet(new LinkedHashSet<TestTag>(tags));
        this.test = test;
        this.container = container;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Optional<String> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isTest() {
        return this.test;
    }

    public boolean isContainer() {
        return this.container;
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Set<TestTag> getTags() {
        return this.tags;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestIdentifier) {
            TestIdentifier that = (TestIdentifier)obj;
            return Objects.equals(this.uniqueId, that.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uniqueId", (Object)this.uniqueId).append("parentId", (Object)this.parentId).append("displayName", (Object)this.displayName).append("source", (Object)this.source).append("tags", this.tags).append("test", (Object)this.test).append("container", (Object)this.container).toString();
    }
}

