/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.tiles;

import com.intellij.javaee.model.xml.Listener;
import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.StrutsPluginDomFactory;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.TilesModel;
import com.intellij.struts.TilesModelProvider;
import com.intellij.struts.psi.TilesModelImpl;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomFileElement;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Struts2TilesModelProvider
implements TilesModelProvider {
    @NonNls
    private static final String STRUTS_TILES_LISTENER_CLASS = "org.apache.struts2.tiles.StrutsTilesListener";
    @NonNls
    private static final String DEFAULT_TILES_XML = "/WEB-INF/tiles.xml";
    @NonNls
    private static final String STRUTS2_TILES_MODEL = "struts2TilesModel";
    private static final Condition<ParamValue> TILES_CONTEXT_PARAM_CONDITION = paramValue -> Comparing.equal((String)"org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG", (String)paramValue.getParamName().getStringValue());

    @NotNull
    public Collection<TilesModel> computeModels(@NotNull Module module) {
        GlobalSearchScope moduleScope;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/tiles/Struts2TilesModelProvider", "computeModels"));
        }
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass strutsTilesListenerClass = facade.findClass(STRUTS_TILES_LISTENER_CLASS, moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false));
        if (strutsTilesListenerClass == null) {
            List<TilesModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/tiles/Struts2TilesModelProvider", "computeModels"));
            }
            return list;
        }
        PsiClass tilesListenerClass = facade.findClass("org.apache.tiles.listener.TilesListener", moduleScope);
        StrutsPluginDomFactory factory = StrutsProjectComponent.getInstance((Project)project).getTilesFactory();
        HashSet struts2TilesModels = new HashSet();
        Consumer consumer = arg_0 -> Struts2TilesModelProvider.lambda$computeModels$1(factory, (Set)struts2TilesModels, arg_0);
        WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil((Project)project);
        Collection webFacets = WebFacet.getInstances((Module)module);
        for (WebFacet webFacet : webFacets) {
            WebApp webApp = webFacet.getRoot();
            if (webApp == null) continue;
            Set<String> tilesConfigNames = Struts2TilesModelProvider.findConfiguredTilesPaths(webApp);
            if (tilesConfigNames.isEmpty()) {
                tilesConfigNames.add(DEFAULT_TILES_XML);
            }
            HashSet tilesFileSet = new HashSet();
            for (String tilesPath : tilesConfigNames) {
                PsiFileSystemItem tilesXmlFile = webDirectoryUtil.findFileByPath(tilesPath, webFacet);
                if (!(tilesXmlFile instanceof XmlFile)) continue;
                tilesFileSet.add((XmlFile)tilesXmlFile);
            }
            List listenerList = webApp.getListeners();
            for (Listener listener : listenerList) {
                PsiClass listenerClass = (PsiClass)listener.getListenerClass().getValue();
                if (!strutsTilesListenerClass.equals(listenerClass) && !Comparing.equal((Object)tilesListenerClass, (Object)listenerClass)) continue;
                consumer.consume((Object)tilesFileSet);
            }
        }
        HashSet hashSet = struts2TilesModels;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/tiles/Struts2TilesModelProvider", "computeModels"));
        }
        return hashSet;
    }

    private static Set<String> findConfiguredTilesPaths(WebApp webApp) {
        THashSet tilesConfigNames = new THashSet();
        ParamValue tilesParamValue = (ParamValue)ContainerUtil.find((Iterable)webApp.getContextParams(), TILES_CONTEXT_PARAM_CONDITION);
        if (tilesParamValue == null) {
            return tilesConfigNames;
        }
        String paramValue = tilesParamValue.getParamValue().getStringValue();
        if (paramValue == null) {
            return tilesConfigNames;
        }
        for (String file : StringUtil.split((String)paramValue, (String)",")) {
            tilesConfigNames.add(file.trim());
        }
        return tilesConfigNames;
    }

    private static /* synthetic */ void lambda$computeModels$1(StrutsPluginDomFactory factory, Set struts2TilesModels, Set definitions) {
        DomFileElement domFileElement = factory.createMergedModelRoot(definitions);
        if (domFileElement != null) {
            struts2TilesModels.add(new TilesModelImpl(definitions, domFileElement, STRUTS2_TILES_MODEL));
        }
    }
}

