/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.reference.common.BeanPropertyPathReference;
import com.intellij.struts2.reference.common.BeanPropertyPathReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;

public class ResultActionPropertyReferenceProvider
extends PsiReferenceProvider {
    private static final String EXPRESSION_START = "${";
    private static final String EXPRESSION_END = "}";

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/reference/ResultActionPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/struts2/reference/ResultActionPropertyReferenceProvider", "getReferencesByElement"));
        }
        Result result = (Result)DomUtil.getDomElement((PsiElement)psiElement);
        assert (result != null) : psiElement.getText();
        Action action = (Action)result.getParentOfType(Action.class, true);
        assert (action != null) : psiElement.getText();
        PsiClass actionClass = action.searchActionClass();
        if (actionClass == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/ResultActionPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final int tagValueStartOffset = ElementManipulators.getOffsetInElement((PsiElement)result.getXmlTag());
        Object[] references = new PsiReference[1];
        String stringValue = result.getStringValue();
        if (!StringUtil.isNotEmpty((String)stringValue)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/ResultActionPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String resultText = StringUtil.replace((String)stringValue, (String)"&", (String)"&amp;");
        int lastExpressionEnd = Math.max(resultText.length(), resultText.lastIndexOf(EXPRESSION_START));
        int startOffset = 0;
        while (startOffset < lastExpressionEnd && (startOffset = resultText.indexOf(EXPRESSION_START, startOffset)) != -1) {
            int length;
            String expressionString;
            int closingBraceIdx = resultText.indexOf(EXPRESSION_END, startOffset += EXPRESSION_START.length());
            if (StringUtil.containsChar((String)(expressionString = resultText.substring(startOffset, startOffset + (length = (closingBraceIdx != -1 ? closingBraceIdx : resultText.length()) - startOffset))), (char)'(')) continue;
            BeanPropertyPathReferenceSet propertyPathReferenceSet = new BeanPropertyPathReferenceSet(expressionString, psiElement, startOffset, '.', actionClass, true){

                public boolean isSoft() {
                    return false;
                }

                @Override
                @NotNull
                protected BeanPropertyPathReference createReference(TextRange range, int index) {
                    TextRange shift = TextRange.from((int)(range.getStartOffset() + tagValueStartOffset), (int)range.getLength());
                    BeanPropertyPathReference beanPropertyPathReference = this.createBeanPropertyPathReference(shift, index);
                    if (beanPropertyPathReference == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/ResultActionPropertyReferenceProvider$1", "createReference"));
                    }
                    return beanPropertyPathReference;
                }
            };
            references = (PsiReference[])ArrayUtil.mergeArrays((Object[])references, (Object[])propertyPathReferenceSet.getPsiReferences());
        }
        if (references == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/ResultActionPropertyReferenceProvider", "getReferencesByElement"));
        }
        return references;
    }
}

