/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.model.jam.convention;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamPackageMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtilBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesCompletionContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamResultPath
extends CommonModelElement.PsiBase
implements JamElement {
    @NonNls
    public static final String ANNOTATION_NAME = "org.apache.struts2.convention.annotation.ResultPath";
    private static final JamConverter<IProperty> PROPERTY_CONVERTER = new JamSimpleReferenceConverter<IProperty>(){

        private Collection<IProperty> getStrutsProperties(JamAttributeElement context) {
            PsiAnnotationMemberValue annotationMemberValue = context.getPsiElement();
            if (annotationMemberValue == null) {
                return Collections.emptyList();
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)annotationMemberValue);
            if (module == null) {
                return Collections.emptyList();
            }
            PropertiesFile strutsPropertiesFile = PropertiesUtilBase.getPropertiesFile((String)"struts", (Module)module, null);
            return strutsPropertiesFile != null ? strutsPropertiesFile.getProperties() : Collections.emptyList();
        }

        public IProperty fromString(@Nullable String s, JamStringAttributeElement<IProperty> context) {
            if (s == null) {
                return null;
            }
            Collection<IProperty> properties = this.getStrutsProperties((JamAttributeElement)context);
            return (IProperty)ContainerUtil.find(properties, property -> Comparing.equal((String)property.getName(), (String)s));
        }

        public Collection<IProperty> getVariants(JamStringAttributeElement<IProperty> context) {
            return this.getStrutsProperties((JamAttributeElement)context);
        }

        @NotNull
        protected LookupElement createLookupElementFor(@NotNull IProperty target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/struts2/model/jam/convention/JamResultPath$1", "createLookupElementFor"));
            }
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)target.getPsiElement())).withIcon(ElementPresentationManager.getIcon((Object)target)).withTailText("=" + target.getValue(), true).withRenderer(PropertiesCompletionContributor.LOOKUP_ELEMENT_RENDERER);
            if (lookupElementBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/jam/convention/JamResultPath$1", "createLookupElementFor"));
            }
            return lookupElementBuilder;
        }
    };
    private static final JamConverter<WebDirectoryElement> VALUE_CONVERTER = new JamSimpleReferenceConverter<WebDirectoryElement>(){

        public WebDirectoryElement fromString(@Nullable String s, JamStringAttributeElement<WebDirectoryElement> context) {
            if (s == null) {
                return null;
            }
            PsiAnnotationMemberValue annotationMemberValue = context.getPsiElement();
            if (annotationMemberValue == null) {
                return null;
            }
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)annotationMemberValue);
            if (webFacet == null) {
                return null;
            }
            WebDirectoryElement webDirectoryElement = WebUtil.getWebUtil().findWebDirectoryElement(s, webFacet);
            if (webDirectoryElement == null) {
                return null;
            }
            return webDirectoryElement.isDirectory() ? webDirectoryElement : null;
        }
    };
    private static final JamStringAttributeMeta.Single<WebDirectoryElement> VALUE_ATTRIBUTE = JamAttributeMeta.singleString((String)"value", VALUE_CONVERTER);
    private static final JamStringAttributeMeta.Single<IProperty> PROPERTY_ATTRIBUTE = JamAttributeMeta.singleString((String)"property", PROPERTY_CONVERTER);
    private static final JamAnnotationMeta RESULT_PATH_META = new JamAnnotationMeta("org.apache.struts2.convention.annotation.ResultPath").addAttribute(VALUE_ATTRIBUTE).addAttribute(PROPERTY_ATTRIBUTE);
    public static final JamClassMeta<JamResultPath> META_CLASS = new JamClassMeta(JamResultPath.class).addAnnotation(RESULT_PATH_META);
    public static final JamPackageMeta<JamResultPath> META_PACKAGE = new JamPackageMeta(JamResultPath.class).addAnnotation(RESULT_PATH_META);

    @JamPsiConnector
    public abstract PsiModifierListOwner getOwner();

    @JamPsiValidity
    public abstract boolean isValid();

    @NotNull
    public PsiElement getPsiElement() {
        PsiModifierListOwner psiModifierListOwner = this.getOwner();
        if (psiModifierListOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/jam/convention/JamResultPath", "getPsiElement"));
        }
        return psiModifierListOwner;
    }

    public JamStringAttributeElement<WebDirectoryElement> getValue() {
        return (JamStringAttributeElement)RESULT_PATH_META.getAttribute(this.getOwner(), VALUE_ATTRIBUTE);
    }

    public JamStringAttributeElement<IProperty> getProperty() {
        return (JamStringAttributeElement)RESULT_PATH_META.getAttribute(this.getOwner(), PROPERTY_ATTRIBUTE);
    }
}

