/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.freemarker;

import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.freemarker.psi.files.FtlXmlNamespaceType;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.ResultType;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.util.Processor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Struts2GlobalVariableProvider
extends FtlGlobalVariableProvider {
    @NotNull
    public List<? extends FtlVariable> getGlobalVariables(FtlFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider", "getGlobalVariables"));
            }
            return list;
        }
        if (StrutsFacet.getInstance(module) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider", "getGlobalVariables"));
            }
            return list;
        }
        ArrayList<FtlVariable> result = new ArrayList<FtlVariable>();
        result.add((FtlVariable)new MyFtlLightVariable("stack", (PsiElement)file, (FtlType)null));
        result.add((FtlVariable)new MyFtlLightVariable("response", (PsiElement)file, "javax.servlet.http.HttpServletResponse"));
        result.add((FtlVariable)new MyFtlLightVariable("res", (PsiElement)file, "javax.servlet.http.HttpServletResponse"));
        result.add((FtlVariable)new MyFtlLightVariable("request", (PsiElement)file, "javax.servlet.http.HttpServletRequest"));
        result.add((FtlVariable)new MyFtlLightVariable("req", (PsiElement)file, "javax.servlet.http.HttpServletRequest"));
        result.add((FtlVariable)new MyFtlLightVariable("session", (PsiElement)file, "javax.servlet.http.HttpSession"));
        result.add((FtlVariable)new MyFtlLightVariable("application", (PsiElement)file, "javax.servlet.ServletContext"));
        result.add((FtlVariable)new MyFtlLightVariable("base", (PsiElement)file, "java.lang.String"));
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-tags", "s");
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-jquery-tags", "sj");
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-jquery-richtext-tags", "sjr");
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-jquery-chart-tags", "sjc");
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-jquery-tree-tags", "sjt");
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-jquery-grid-tags", "sjg");
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-jquery-mobile-tags", "sjm");
        Struts2GlobalVariableProvider.installTaglibSupport(result, module, "/struts-bootstrap-tags", "sb");
        Processor processor = action -> {
            PsiClass actionClass = action.searchActionClass();
            if (actionClass != null) {
                for (Result result1 : action.getResults()) {
                    PathReference reference;
                    PsiElement target;
                    ResultType resultType = result1.getEffectiveResultType();
                    if (resultType == null || !"freemarker".equals(resultType.getName().getStringValue()) || (target = (reference = (PathReference)result1.getValue()) == null ? null : reference.resolve()) == null || !file.getManager().areElementsEquivalent((PsiElement)file, target) && !file.getManager().areElementsEquivalent((PsiElement)file.getOriginalFile(), target)) continue;
                    PsiClassType actionType = PsiTypesUtil.getClassType((PsiClass)actionClass);
                    FtlPsiType ftlPsiType = FtlPsiType.wrap((PsiType)actionType);
                    result.add((FtlVariable)new MyFtlLightVariable("", (PsiElement)action.getXmlTag(), (FtlType)ftlPsiType));
                    result.add((FtlVariable)new MyFtlLightVariable("action", (PsiElement)action.getXmlTag(), (FtlType)ftlPsiType));
                    return false;
                }
            }
            return true;
        };
        for (StrutsModel model : StrutsManager.getInstance(file.getProject()).getAllModels(module)) {
            model.processActions((Processor<Action>)processor);
        }
        ArrayList<FtlVariable> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider", "getGlobalVariables"));
        }
        return arrayList;
    }

    private static void installTaglibSupport(@NotNull List<FtlVariable> result, @NotNull Module module, @NotNull @NonNls String taglibUri, @NotNull @NonNls String taglibPrefix) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider", "installTaglibSupport"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider", "installTaglibSupport"));
        }
        if (taglibUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taglibUri", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider", "installTaglibSupport"));
        }
        if (taglibPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taglibPrefix", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider", "installTaglibSupport"));
        }
        XmlFile xmlFile = JspManager.getInstance((Project)module.getProject()).getTldFileByUri(taglibUri, module, null);
        if (xmlFile == null) {
            return;
        }
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return;
        }
        XmlNSDescriptor descriptor = (XmlNSDescriptor)document.getMetaData();
        if (descriptor == null) {
            return;
        }
        PsiElement declaration = descriptor.getDeclaration();
        if (declaration == null) {
            declaration = xmlFile;
        }
        result.add((FtlVariable)new MyFtlLightVariable(taglibPrefix, declaration, (FtlType)new FtlXmlNamespaceType(descriptor)));
    }

    private static class MyFtlLightVariable
    extends FtlLightVariable {
        private MyFtlLightVariable(@NotNull @NonNls String name, @NotNull PsiElement parent, @Nullable FtlType type) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider$MyFtlLightVariable", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider$MyFtlLightVariable", "<init>"));
            }
            super(name, parent, type);
        }

        private MyFtlLightVariable(@NotNull @NonNls String name, @NotNull PsiElement parent, @NotNull @NonNls String psiType) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider$MyFtlLightVariable", "<init>"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider$MyFtlLightVariable", "<init>"));
            }
            if (psiType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/struts2/freemarker/Struts2GlobalVariableProvider$MyFtlLightVariable", "<init>"));
            }
            super(name, parent, psiType);
        }

        public Icon getIcon(boolean open) {
            return StrutsIcons.STRUTS_VARIABLE;
        }
    }
}

