/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.validator;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.validator.ValidatorManager;
import com.intellij.struts2.dom.validator.Validators;
import com.intellij.struts2.dom.validator.config.ValidatorConfig;
import com.intellij.struts2.dom.validator.config.ValidatorsConfig;
import com.intellij.struts2.facet.ui.StrutsVersionDetector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidatorManagerImpl
extends ValidatorManager {
    @NonNls
    private static final String VALIDATORS_XML = "validators.xml";
    @NonNls
    private static final String VALIDATORS_DEFAULT_XML = "default.xml";

    @Override
    public boolean isValidatorsFile(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "isValidatorsFile"));
        }
        return DomManager.getDomManager((Project)xmlFile.getProject()).getFileElement(xmlFile, Validators.class) != null;
    }

    @Nullable
    private static DomFileElement<ValidatorsConfig> getValidatorsConfigFileElement(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "getValidatorsConfigFileElement"));
        }
        return DomManager.getDomManager((Project)xmlFile.getProject()).getFileElement(xmlFile, ValidatorsConfig.class);
    }

    @Override
    public boolean isCustomValidatorConfigFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "isCustomValidatorConfigFile"));
        }
        return !Comparing.equal((String)psiFile.getName(), (String)VALIDATORS_DEFAULT_XML);
    }

    @Override
    public List<ValidatorConfig> getValidators(@NotNull Module module) {
        XmlFile defaultValidatorFile;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "getValidators"));
        }
        XmlFile validatorsFile = this.getValidatorConfigFile(module);
        if (validatorsFile == null) {
            return Collections.emptyList();
        }
        DomFileElement<ValidatorsConfig> validatorsConfigElement = ValidatorManagerImpl.getValidatorsConfigFileElement(validatorsFile);
        if (validatorsConfigElement == null) {
            return Collections.emptyList();
        }
        List validatorConfigs = ((ValidatorsConfig)validatorsConfigElement.getRootElement()).getValidatorConfigs();
        if (!this.isCustomValidatorConfigFile((PsiFile)validatorsFile)) {
            return validatorConfigs;
        }
        String version = StrutsVersionDetector.detectStrutsVersion(module);
        if (StringUtil.compareVersionNumbers((String)version, (String)"2.0.8") == 1 && (defaultValidatorFile = ValidatorManagerImpl.findDefaultValidatorsFile(module)) != null) {
            DomFileElement<ValidatorsConfig> fileElement = ValidatorManagerImpl.getValidatorsConfigFileElement(defaultValidatorFile);
            if (fileElement == null) {
                return validatorConfigs;
            }
            List defaultValidators = ((ValidatorsConfig)fileElement.getRootElement()).getValidatorConfigs();
            ArrayList<ValidatorConfig> allValidatorConfigs = new ArrayList<ValidatorConfig>(defaultValidators);
            allValidatorConfigs.addAll(validatorConfigs);
            return allValidatorConfigs;
        }
        return validatorConfigs;
    }

    @Override
    @Nullable
    public XmlFile getValidatorConfigFile(@NotNull Module module) {
        PsiFile file;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "getValidatorConfigFile"));
        }
        Project project = module.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile validatorsVirtualFile = ResourceFileUtil.findResourceFileInScope((String)VALIDATORS_XML, (Project)project, (GlobalSearchScope)GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false));
        if (validatorsVirtualFile != null && (file = psiManager.findFile(validatorsVirtualFile)) != null && ValidatorManagerImpl.getValidatorsConfigFileElement((XmlFile)file) != null) {
            return (XmlFile)file;
        }
        return ValidatorManagerImpl.findDefaultValidatorsFile(module);
    }

    @Override
    @NotNull
    public List<XmlFile> findValidationFilesFor(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "findValidationFilesFor"));
        }
        PsiFile psiFile = clazz.getContainingFile().getOriginalFile();
        PsiDirectory containingDirectory = psiFile.getContainingDirectory();
        if (containingDirectory == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "findValidationFilesFor"));
            }
            return list;
        }
        PsiPackage containingPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
        if (containingPackage == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "findValidationFilesFor"));
            }
            return list;
        }
        PackageScope searchScope = new PackageScope(containingPackage, false, true);
        List validationRoots = DomService.getInstance().getFileElements(Validators.class, clazz.getProject(), (GlobalSearchScope)searchScope);
        List filtered = ContainerUtil.filter((Collection)validationRoots, validatorDomFileElement -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "lambda$findValidationFilesFor$0"));
            }
            String fileName = validatorDomFileElement.getFile().getName();
            return StringUtil.startsWith((CharSequence)fileName, (CharSequence)clazz.getName());
        });
        List list = ContainerUtil.map((Collection)filtered, validatorsDomFileElement -> validatorsDomFileElement.getFile());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/validator/ValidatorManagerImpl", "findValidationFilesFor"));
        }
        return list;
    }

    @Nullable
    private static XmlFile findDefaultValidatorsFile(Module module) {
        Project project = module.getProject();
        PsiClass emailValidatorClass = JavaPsiFacade.getInstance((Project)project).findClass("com.opensymphony.xwork2.validator.validators.EmailValidator", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false));
        if (emailValidatorClass == null) {
            return null;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)emailValidatorClass);
        if (file == null || file.getFileSystem() != JarFileSystem.getInstance()) {
            return null;
        }
        VirtualFile parent = file.getParent();
        assert (parent != null) : "error walking up to parent from EmailValidator.class, xwork JAR file=" + file;
        VirtualFile vfDefaultXml = parent.findChild(VALIDATORS_DEFAULT_XML);
        assert (vfDefaultXml != null) : "VF for default.xml null, parent=" + parent;
        return (XmlFile)PsiManager.getInstance((Project)project).findFile(vfDefaultXml);
    }
}

