/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl.path;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.struts2.dom.struts.impl.path.StrutsResultContributor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultTypeResolver {
    @NonNls
    private static final String[] RESULT_TYPES_CHAIN_REDIRECT = new String[]{"chain", "redirect-action", "redirectAction"};
    @NonNls
    private static final String[] RESULT_TYPES_DISPATCH = new String[]{"dispatcher", "plainText", "redirect"};

    private ResultTypeResolver() {
    }

    public static boolean isChainOrRedirectType(@NotNull String resultType) {
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/struts2/dom/struts/impl/path/ResultTypeResolver", "isChainOrRedirectType"));
        }
        return Arrays.binarySearch(RESULT_TYPES_CHAIN_REDIRECT, resultType) >= 0;
    }

    public static boolean isDispatchType(@NotNull String resultType) {
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/struts2/dom/struts/impl/path/ResultTypeResolver", "isDispatchType"));
        }
        return Arrays.binarySearch(RESULT_TYPES_DISPATCH, resultType) >= 0;
    }

    public static boolean hasResultTypeContributor(@Nullable String resultType) {
        if (resultType == null) {
            return false;
        }
        if (ResultTypeResolver.isDispatchType(resultType) || ResultTypeResolver.isChainOrRedirectType(resultType)) {
            return true;
        }
        Object[] contributors = (StrutsResultContributor[])Extensions.getExtensions(StrutsResultContributor.EP_NAME);
        return ContainerUtil.find((Object[])contributors, strutsResultContributor -> strutsResultContributor.matchesResultType(resultType)) != null;
    }
}

