/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl.path;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.impl.path.ResultTypeResolver;
import com.intellij.struts2.dom.struts.impl.path.StrutsResultContributor;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.model.constant.StrutsConstantHelper;
import com.intellij.util.ArrayUtil;
import icons.Struts2Icons;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionPathResultContributor
extends StrutsResultContributor {
    @Override
    public boolean matchesResultType(@NotNull @NonNls String resultType) {
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/struts2/dom/struts/impl/path/ActionPathResultContributor", "matchesResultType"));
        }
        return ResultTypeResolver.isDispatchType(resultType);
    }

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/dom/struts/impl/path/ActionPathResultContributor", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/struts2/dom/struts/impl/path/ActionPathResultContributor", "createReferences"));
        }
        StrutsModel model = StrutsManager.getInstance(psiElement.getProject()).getModelByFile((XmlFile)psiElement.getContainingFile());
        if (model == null) {
            return false;
        }
        String currentPackage = this.getNamespace(psiElement);
        if (currentPackage == null) {
            return false;
        }
        TextRange rangeInElement = ElementManipulators.getManipulator((PsiElement)psiElement).getRangeInElement(psiElement);
        String fullPath = psiElement.getText();
        String trimmedPath = rangeInElement.substring(fullPath);
        TextRange trimmedPathRange = TextRange.from((int)rangeInElement.getStartOffset(), (int)PathReference.trimPath((String)trimmedPath).length());
        ActionPathReference actionReference = new ActionPathReference((XmlTag)psiElement, trimmedPathRange, currentPackage, model);
        references.add((PsiReference)actionReference);
        return false;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/struts2/dom/struts/impl/path/ActionPathResultContributor", "getPathReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/dom/struts/impl/path/ActionPathResultContributor", "getPathReference"));
        }
        return this.createDefaultPathReference(path, element, Struts2Icons.Action);
    }

    private static class ActionPathReference
    extends PsiReferenceBase<XmlTag> {
        private final String currentPackage;
        private final StrutsModel model;

        private ActionPathReference(XmlTag psiElement, TextRange textRange, String currentPackage, StrutsModel model) {
            super((PsiElement)psiElement, textRange, true);
            this.currentPackage = currentPackage;
            this.model = model;
        }

        private List<String> getActionExtensions() {
            return StrutsConstantHelper.getActionExtensions(this.myElement);
        }

        public PsiElement resolve() {
            String actionExtension;
            String path = this.getCanonicalText();
            int extensionIndex = -1;
            Iterator<String> iterator = this.getActionExtensions().iterator();
            while (iterator.hasNext() && (extensionIndex = path.lastIndexOf(actionExtension = iterator.next())) == -1) {
            }
            if (extensionIndex == -1) {
                return null;
            }
            int namespacePrefixIndex = path.lastIndexOf("/");
            String namespace = namespacePrefixIndex != -1 ? path.substring(0, namespacePrefixIndex) : this.currentPackage;
            if (namespacePrefixIndex > extensionIndex) {
                return null;
            }
            String strippedPath = path.substring(namespacePrefixIndex != -1 ? namespacePrefixIndex + 1 : 0, extensionIndex);
            List<Action> actions = this.model.findActionsByName(strippedPath, namespace);
            if (actions.size() == 1) {
                Action action = actions.get(0);
                return action.getXmlTag();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            List<String> extensions = this.getActionExtensions();
            if (extensions.isEmpty()) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/path/ActionPathResultContributor$ActionPathReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            String firstExtension = extensions.get(0);
            List<Action> allActions = this.model.getActionsForNamespace(null);
            ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(allActions.size());
            for (Action action : allActions) {
                String actionPath = action.getName().getStringValue();
                if (actionPath == null) continue;
                boolean isInCurrentPackage = Comparing.equal((String)action.getNamespace(), (String)this.currentPackage);
                String actionNamespace = action.getNamespace();
                String fullPath = !Comparing.equal((String)actionNamespace, (String)"/") && !isInCurrentPackage ? actionNamespace + "/" + actionPath + firstExtension : actionPath + firstExtension;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)action.getXmlTag(), (String)fullPath).withBoldness(isInCurrentPackage).withIcon(Struts2Icons.Action).withTypeText(action.getNamespace());
                variants.add(builder);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/path/ActionPathResultContributor$ActionPathReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

