/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.dom.ExtendableClassConverter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.ExtendClass;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendableClassConverterSpringContributor
extends ExtendableClassConverter.ExtendableClassConverterContributor {
    @NotNull
    public String getTypeName() {
        String string = StrutsBundle.message("dom.extendable.class.converter.type.spring", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor", "getTypeName"));
        }
        return string;
    }

    public boolean isSuitable(@NotNull ConvertContext convertContext) {
        if (convertContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertContext", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor", "isSuitable"));
        }
        Module module = convertContext.getModule();
        if (module == null) {
            return false;
        }
        if (!SpringCommonUtils.hasSpringFacet((Module)module)) {
            return false;
        }
        return DomJavaUtil.findClass((String)"org.apache.struts2.spring.StrutsSpringObjectFactory", (DomElement)convertContext.getInvocationElement()) != null;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull ConvertContext convertContext, @NotNull PsiElement psiElement, @NotNull ExtendClass extendClass) {
        if (convertContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertContext", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor", "getReferences"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor", "getReferences"));
        }
        if (extendClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendClass", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor", "getReferences"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference((XmlAttributeValue)psiElement, convertContext.getModule(), extendClass)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor", "getReferences"));
        }
        return psiReferenceArray;
    }

    private static class SpringBeanReference
    extends PsiReferenceBase<XmlAttributeValue> {
        private final Module module;
        private final ExtendClass extendClass;

        private SpringBeanReference(XmlAttributeValue element, Module module, ExtendClass extendClass) {
            super((PsiElement)element, true);
            this.module = module;
            this.extendClass = extendClass;
        }

        @NotNull
        private SpringModel getSpringModel() {
            SpringModel springModel = SpringManager.getInstance((Project)this.module.getProject()).getCombinedModel(this.module);
            if (springModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor$SpringBeanReference", "getSpringModel"));
            }
            return springModel;
        }

        public PsiElement resolve() {
            String beanName = ((XmlAttributeValue)this.myElement).getValue();
            if (StringUtil.isEmpty((String)beanName)) {
                return null;
            }
            SpringModel springModel = this.getSpringModel();
            SpringBeanPointer springBean = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)beanName);
            if (springBean == null) {
                return null;
            }
            if (springBean.isAbstract()) {
                return null;
            }
            return springBean.getBeanClass();
        }

        @NotNull
        public Object[] getVariants() {
            SpringModel springModel = this.getSpringModel();
            PsiClass subClass = this.getPossibleSubClass();
            Collection list = subClass != null ? SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)subClass).withInheritors()) : springModel.getAllCommonBeans();
            ArrayList variants = new ArrayList(list.size());
            for (SpringBeanPointer bean : list) {
                if (bean.isAbstract()) continue;
                ContainerUtil.addIfNotNull(variants, (Object)SpringConverterUtil.createCompletionVariant((SpringBeanPointer)bean));
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants, LookupElement.class);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ExtendableClassConverterSpringContributor$SpringBeanReference", "getVariants"));
            }
            return objectArray;
        }

        @Nullable
        private PsiClass getPossibleSubClass() {
            String subClassName = this.extendClass.value();
            if (subClassName == null) {
                return null;
            }
            GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module, (boolean)false);
            return JavaPsiFacade.getInstance((Project)this.module.getProject()).findClass(subClassName, searchScope);
        }
    }
}

