/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.annotators;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.Struts2Icons;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspActionAnnotator
extends LineMarkerProviderDescriptor {
    @NonNls
    private static final String ACTION_ATTRIBUTE_NAME = "action";
    @NonNls
    private static final String[] TAGS_WITH_ACTION_ATTRIBUTE = new String[]{"action", "form", "reset", "submit", "url"};
    private static final NullableFunction<Action, PsiMethod> ACTION_METHOD_FUNCTION = action -> action.searchActionMethod();

    public String getId() {
        return "JspActionAnnotator";
    }

    @NotNull
    public String getName() {
        if ("Action (JSP)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/annotators/JspActionAnnotator", "getName"));
        }
        return "Action (JSP)";
    }

    @Nullable
    public Icon getIcon() {
        return Struts2Icons.Action;
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/annotators/JspActionAnnotator", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> psiElements, @NotNull Collection<LineMarkerInfo> lineMarkerInfos) {
        if (psiElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElements", "com/intellij/struts2/annotators/JspActionAnnotator", "collectSlowLineMarkers"));
        }
        if (lineMarkerInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineMarkerInfos", "com/intellij/struts2/annotators/JspActionAnnotator", "collectSlowLineMarkers"));
        }
        if (psiElements.isEmpty()) {
            return;
        }
        for (PsiElement element : psiElements) {
            JspActionAnnotator.annotate(element, lineMarkerInfos);
        }
    }

    private static void annotate(@NotNull PsiElement element, @NotNull Collection<LineMarkerInfo> lineMarkerInfos) {
        String actionPath;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/annotators/JspActionAnnotator", "annotate"));
        }
        if (lineMarkerInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineMarkerInfos", "com/intellij/struts2/annotators/JspActionAnnotator", "annotate"));
        }
        if (!(element instanceof XmlTag)) {
            return;
        }
        XmlTag xmlTag = (XmlTag)element;
        String tagName = xmlTag.getLocalName();
        if (Arrays.binarySearch(TAGS_WITH_ACTION_ATTRIBUTE, tagName) < 0) {
            return;
        }
        if (!Comparing.equal((String)xmlTag.getNamespace(), (String)"/struts-tags")) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        if (StrutsFacet.getInstance(module) == null) {
            return;
        }
        String string = actionPath = Comparing.equal((String)tagName, (String)ACTION_ATTRIBUTE_NAME) ? xmlTag.getAttributeValue("name") : xmlTag.getAttributeValue(ACTION_ATTRIBUTE_NAME);
        if (actionPath == null) {
            return;
        }
        StrutsModel strutsModel = StrutsManager.getInstance(element.getProject()).getCombinedModel(module);
        if (strutsModel == null) {
            return;
        }
        String namespace = xmlTag.getAttributeValue("namespace");
        final List<Action> actions = strutsModel.findActionsByName(actionPath, namespace);
        if (actions.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder gutterIconBuilder = NavigationGutterIconBuilder.create((Icon)StrutsIcons.ACTION_CLASS).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(StrutsBundle.message("annotators.jsp.goto.action.method", new Object[0])).setEmptyPopupText(StrutsBundle.message("annotators.jsp.goto.action.method.not.found", new Object[0])).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            protected Collection<PsiMethod> compute() {
                List list = ContainerUtil.mapNotNull((Collection)actions, (Function)ACTION_METHOD_FUNCTION);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/annotators/JspActionAnnotator$1", "compute"));
                }
                return list;
            }
        });
        lineMarkerInfos.add((LineMarkerInfo)gutterIconBuilder.createLineMarkerInfo((PsiElement)xmlTag));
    }
}

