/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.wizard.FormProperty;
import com.intellij.uiDesigner.wizard.FormProperty2BeanProperty;
import com.intellij.uiDesigner.wizard.Generator;
import org.jetbrains.annotations.NotNull;

public final class WizardData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.wizard.WizardData");
    @NotNull
    public final Project myProject;
    @NotNull
    public final VirtualFile myFormFile;
    public boolean myBindToNewBean;
    public String myShortClassName;
    public String myPackageName;
    public PsiClass myBeanClass;
    @NotNull
    public final FormProperty2BeanProperty[] myBindings;
    public boolean myGenerateIsModified;

    public WizardData(@NotNull Project project, @NotNull VirtualFile formFile) throws Generator.MyException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uiDesigner/wizard/WizardData", "<init>"));
        }
        if (formFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFile", "com/intellij/uiDesigner/wizard/WizardData", "<init>"));
        }
        this.myProject = project;
        this.myFormFile = formFile;
        this.myBindToNewBean = true;
        this.myGenerateIsModified = true;
        LwRootContainer[] rootContainer = new LwRootContainer[1];
        FormProperty[] formProperties = Generator.exposeForm(this.myProject, this.myFormFile, rootContainer);
        this.myBindings = new FormProperty2BeanProperty[formProperties.length];
        for (int i = formProperties.length - 1; i >= 0; --i) {
            this.myBindings[i] = new FormProperty2BeanProperty(formProperties[i]);
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        VirtualFile directory = formFile.getParent();
        LOG.assertTrue(directory.isDirectory());
        PsiDirectory psiDirectory = manager.findDirectory(directory);
        LOG.assertTrue(psiDirectory != null);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
        if (aPackage != null) {
            this.myPackageName = aPackage.getQualifiedName();
        }
    }
}

