/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.compiler.GridBagConverter;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FirstComponentInsertLocation;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.PrimitiveTypeEditor;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractInsetsProperty;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractIntProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HorzAlignProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VertAlignProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadGridBagLayoutManager
extends RadAbstractGridLayoutManager {
    private int myLastSnapshotRow = -1;
    private int myLastSnapshotCol = -1;
    private final int[] mySnapshotXMax = new int[512];
    private final int[] mySnapshotYMax = new int[512];
    private static final int MINIMUM_GRID_SIZE = 15;

    @Override
    public String getName() {
        return "GridBagLayout";
    }

    @Override
    public LayoutManager createLayout() {
        return new GridBagLayout();
    }

    @Override
    public void changeContainerLayout(RadContainer container) throws IncorrectOperationException {
        if (container.getLayoutManager().isGrid()) {
            RadAbstractGridLayoutManager grid = container.getGridLayoutManager();
            for (RadComponent c : container.getComponents()) {
                GridBagConstraints gbc = GridBagConverter.getGridBagConstraints((IComponent)c);
                if (grid.canCellGrow(container, false, c.getConstraints().getColumn())) {
                    gbc.weightx = 1.0;
                }
                if (grid.canCellGrow(container, true, c.getConstraints().getRow())) {
                    gbc.weighty = 1.0;
                }
                c.setCustomLayoutConstraints(gbc);
            }
        }
        super.changeContainerLayout(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        RadGridBagLayoutManager.writeGridConstraints(writer, child);
        if (child.getCustomLayoutConstraints() instanceof GridBagConstraints) {
            GridBagConstraints gbc = (GridBagConstraints)child.getCustomLayoutConstraints();
            writer.startElement("gridbag");
            try {
                if (!gbc.insets.equals(new Insets(0, 0, 0, 0))) {
                    writer.addAttribute("top", gbc.insets.top);
                    writer.addAttribute("left", gbc.insets.left);
                    writer.addAttribute("bottom", gbc.insets.bottom);
                    writer.addAttribute("right", gbc.insets.right);
                }
                writer.addAttribute("weightx", gbc.weightx);
                writer.addAttribute("weighty", gbc.weighty);
                if (gbc.ipadx != 0) {
                    writer.addAttribute("ipadx", gbc.ipadx);
                }
                if (gbc.ipady != 0) {
                    writer.addAttribute("ipady", gbc.ipady);
                }
            }
            finally {
                writer.endElement();
            }
        }
    }

    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        super.addComponentToContainer(container, component, index);
        GridBagConstraints gbc = GridBagConverter.getGridBagConstraints((IComponent)component);
        component.setCustomLayoutConstraints(gbc);
        container.getDelegee().add(component.getDelegee(), gbc, index);
    }

    @Override
    public void refresh(RadContainer container) {
        RadGridBagLayoutManager.checkEmptyCells(container);
    }

    private static void checkEmptyCells(RadContainer container) {
        JComponent jComponent = container.getDelegee();
        GridBagLayout layout = (GridBagLayout)jComponent.getLayout();
        Dimension oldSize = jComponent.getSize();
        layout.columnWidths = null;
        layout.rowHeights = null;
        jComponent.setSize(500, 400);
        jComponent.doLayout();
        jComponent.setSize(oldSize);
        int[][] dimensions = layout.getLayoutDimensions();
        int[] columnWidths = dimensions[0];
        boolean doLayoutColumns = false;
        for (int i = 0; i < columnWidths.length; ++i) {
            if (columnWidths[i] != 0) continue;
            columnWidths[i] = 15;
            doLayoutColumns = true;
        }
        int[] rowHeights = dimensions[1];
        boolean doLayoutRows = false;
        for (int i = 0; i < rowHeights.length; ++i) {
            if (rowHeights[i] != 0) continue;
            rowHeights[i] = 15;
            doLayoutRows = true;
        }
        if (doLayoutColumns) {
            layout.columnWidths = columnWidths;
        }
        if (doLayoutRows) {
            layout.rowHeights = rowHeights;
        }
        if (doLayoutColumns || doLayoutRows) {
            jComponent.doLayout();
        }
    }

    @Override
    public Property[] getContainerProperties(Project project) {
        return Property.EMPTY_ARRAY;
    }

    @Override
    public Property[] getComponentProperties(Project project, RadComponent component) {
        return new Property[]{new HorzAlignProperty(), new VertAlignProperty(), new ComponentInsetsProperty(), new WeightProperty(true), new WeightProperty(false), new IPadProperty(true), new IPadProperty(false)};
    }

    private static GridBagLayout getGridBag(RadContainer container) {
        return (GridBagLayout)container.getLayout();
    }

    @Override
    public int getGridRowCount(RadContainer container) {
        int[][] layoutDimensions = RadGridBagLayoutManager.getGridBag(container).getLayoutDimensions();
        return layoutDimensions[1].length;
    }

    @Override
    public int getGridColumnCount(RadContainer container) {
        int[][] layoutDimensions = RadGridBagLayoutManager.getGridBag(container).getLayoutDimensions();
        return layoutDimensions[0].length;
    }

    @Override
    public int[] getHorizontalGridLines(RadContainer container) {
        return RadGridBagLayoutManager.getGridLines(container, 1, 1);
    }

    @Override
    public int[] getVerticalGridLines(RadContainer container) {
        return RadGridBagLayoutManager.getGridLines(container, 0, 1);
    }

    @Override
    public int[] getGridCellCoords(RadContainer container, boolean isRow) {
        return RadGridBagLayoutManager.getGridLines(container, isRow ? 1 : 0, 0);
    }

    @Override
    public int[] getGridCellSizes(RadContainer container, boolean isRow) {
        int[][] layoutDimensions = RadGridBagLayoutManager.getGridBag(container).getLayoutDimensions();
        return layoutDimensions[isRow ? 1 : 0];
    }

    private static int[] getGridLines(RadContainer container, int rowColIndex, int delta) {
        GridBagLayout gridBag = RadGridBagLayoutManager.getGridBag(container);
        Point layoutOrigin = gridBag.getLayoutOrigin();
        int[][] layoutDimensions = gridBag.getLayoutDimensions();
        int[] result = new int[layoutDimensions[rowColIndex].length + delta];
        if (result.length > 0) {
            result[0] = rowColIndex == 0 ? layoutOrigin.x : layoutOrigin.y;
            for (int i = 1; i < result.length; ++i) {
                result[i] = result[i - 1] + layoutDimensions[rowColIndex][i - 1];
            }
        }
        return result;
    }

    @Override
    @NotNull
    public ComponentDropLocation getDropLocation(@NotNull RadContainer container, @Nullable Point location) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/uiDesigner/radComponents/RadGridBagLayoutManager", "getDropLocation"));
        }
        if (this.getGridRowCount(container) == 0 && this.getGridColumnCount(container) == 0) {
            FirstComponentInsertLocation firstComponentInsertLocation = new FirstComponentInsertLocation(container, new Rectangle(0, 0, container.getWidth(), container.getHeight()), 0, 0);
            if (firstComponentInsertLocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadGridBagLayoutManager", "getDropLocation"));
            }
            return firstComponentInsertLocation;
        }
        ComponentDropLocation componentDropLocation = super.getDropLocation(container, location);
        if (componentDropLocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadGridBagLayoutManager", "getDropLocation"));
        }
        return componentDropLocation;
    }

    @Override
    public void copyGridSection(RadContainer source, RadContainer destination, Rectangle rc) {
        destination.setLayout(new GridBagLayout());
    }

    @Override
    protected void updateConstraints(RadComponent component) {
        GridBagLayout layout = (GridBagLayout)component.getParent().getLayout();
        GridBagConstraints gbc = GridBagConverter.getGridBagConstraints((IComponent)component);
        layout.setConstraints(component.getDelegee(), gbc);
        super.updateConstraints(component);
    }

    @Override
    public boolean isGridDefinedByComponents() {
        return true;
    }

    @Override
    public boolean canResizeCells() {
        return false;
    }

    @Override
    public boolean canCellGrow(RadContainer container, boolean isRow, int i) {
        GridBagLayout gridBag = RadGridBagLayoutManager.getGridBag(container);
        double[][] weights = gridBag.getLayoutWeights();
        if (weights != null) {
            double[] cellWeights = weights[isRow ? 1 : 0];
            return i >= 0 && i < cellWeights.length && cellWeights[i] >= 0.1;
        }
        return false;
    }

    @Override
    public void setChildDragging(RadComponent child, boolean dragging) {
    }

    @Override
    public void createSnapshotLayout(SnapshotContext context, JComponent parent, RadContainer container, LayoutManager layout) {
        container.setLayout(new GridBagLayout());
    }

    public static Dimension getGridBagSize(JComponent parent) {
        GridBagLayout gridBag = (GridBagLayout)parent.getLayout();
        gridBag.layoutContainer(parent);
        int[][] layoutDimensions = gridBag.getLayoutDimensions();
        int rowCount = layoutDimensions[1].length;
        int colCount = layoutDimensions[0].length;
        for (Component component : parent.getComponents()) {
            GridBagConstraints constraints = gridBag.getConstraints(component);
            colCount = Math.max(colCount, constraints.gridx + constraints.gridwidth);
            rowCount = Math.max(rowCount, constraints.gridy + constraints.gridheight);
        }
        return new Dimension(colCount, rowCount);
    }

    @Override
    public void addSnapshotComponent(JComponent parent, JComponent child, RadContainer container, RadComponent component) {
        int i;
        Dimension gridBagSize = RadGridBagLayoutManager.getGridBagSize(parent);
        GridBagLayout gridBag = (GridBagLayout)parent.getLayout();
        GridBagConstraints constraints = gridBag.getConstraints(child);
        int curX = constraints.gridx;
        int curY = constraints.gridy;
        int curWidth = constraints.gridwidth;
        int curHeight = constraints.gridheight;
        if (curX < 0 && curY < 0) {
            if (this.myLastSnapshotRow >= 0) {
                curY = this.myLastSnapshotRow;
            } else if (this.myLastSnapshotCol >= 0) {
                curX = this.myLastSnapshotCol;
            } else {
                curY = 0;
            }
        }
        if (curX < 0) {
            if (curHeight <= 0 && (curHeight += gridBagSize.height - curY) < 1) {
                curHeight = 1;
            }
            int px = 0;
            for (i = curY; i < curY + curHeight; ++i) {
                px = Math.max(px, this.mySnapshotXMax[i]);
            }
            if ((curX = px - curX - 1) < 0) {
                curX = 0;
            }
        } else if (curY < 0) {
            if (curWidth <= 0 && (curWidth += gridBagSize.width - curX) < 1) {
                curWidth = 1;
            }
            int py = 0;
            for (i = curX; i < curX + curWidth; ++i) {
                py = Math.max(py, this.mySnapshotYMax[i]);
            }
            if ((curY = py - curY - 1) < 0) {
                curY = 0;
            }
        }
        if (curWidth <= 0 && (curWidth += gridBagSize.width - curX) < 1) {
            curWidth = 1;
        }
        if (curHeight <= 0 && (curHeight += gridBagSize.height - curY) < 1) {
            curHeight = 1;
        }
        for (i = curX; i < curX + curWidth; ++i) {
            this.mySnapshotYMax[i] = curY + curHeight;
        }
        for (i = curY; i < curY + curHeight; ++i) {
            this.mySnapshotXMax[i] = curX + curWidth;
        }
        if (constraints.gridheight == 0 && constraints.gridwidth == 0) {
            this.myLastSnapshotCol = -1;
            this.myLastSnapshotRow = -1;
        }
        if (constraints.gridheight == 0 && this.myLastSnapshotRow < 0) {
            this.myLastSnapshotCol = curX + curWidth;
        } else if (constraints.gridwidth == 0 && this.myLastSnapshotCol < 0) {
            this.myLastSnapshotRow = curY + curHeight;
        }
        component.getConstraints().setColumn(curX);
        component.getConstraints().setRow(curY);
        component.getConstraints().setColSpan(curWidth);
        component.getConstraints().setRowSpan(curHeight);
        if (constraints.weightx >= 1.0) {
            component.getConstraints().setHSizePolicy(6);
        } else {
            component.getConstraints().setHSizePolicy(0);
        }
        if (constraints.weighty >= 1.0) {
            component.getConstraints().setVSizePolicy(6);
        } else {
            component.getConstraints().setVSizePolicy(0);
        }
        if (constraints.insets.right == 0 && constraints.insets.top == 0 && constraints.insets.bottom == 0) {
            component.getConstraints().setIndent(constraints.insets.left / 10);
        }
        component.getConstraints().setAnchor(RadGridBagLayoutManager.convertAnchor(constraints));
        component.getConstraints().setFill(RadGridBagLayoutManager.convertFill(constraints));
        component.setCustomLayoutConstraints(constraints.clone());
        container.addComponent(component);
    }

    private static int convertAnchor(GridBagConstraints gbc) {
        switch (gbc.anchor) {
            case 18: {
                return 9;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 4;
            }
            case 14: {
                return 6;
            }
            case 15: {
                return 2;
            }
            case 16: {
                return 10;
            }
        }
        return 8;
    }

    private static int convertFill(GridBagConstraints gbc) {
        switch (gbc.fill) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    private static class IPadProperty
    extends AbstractIntProperty<RadComponent> {
        private final boolean myIsIpadX;

        public IPadProperty(boolean isIpadX) {
            super(null, isIpadX ? "Ipad X" : "Ipad Y", 0);
            this.myIsIpadX = isIpadX;
        }

        @Override
        public Integer getValue(RadComponent component) {
            if (component.getCustomLayoutConstraints() instanceof GridBagConstraints) {
                GridBagConstraints gbc = (GridBagConstraints)component.getCustomLayoutConstraints();
                return this.myIsIpadX ? gbc.ipadx : gbc.ipady;
            }
            return 0;
        }

        @Override
        protected void setValueImpl(RadComponent component, Integer value) throws Exception {
            if (component.getCustomLayoutConstraints() instanceof GridBagConstraints) {
                GridBagConstraints gbc = (GridBagConstraints)component.getCustomLayoutConstraints();
                if (this.myIsIpadX) {
                    gbc.ipadx = value;
                } else {
                    gbc.ipady = value;
                }
                ((GridBagLayout)component.getParent().getLayout()).setConstraints(component.getDelegee(), gbc);
            }
        }
    }

    private static class WeightProperty
    extends Property<RadComponent, Double> {
        private final boolean myIsWeightX;
        private LabelPropertyRenderer<Double> myRenderer;
        private PropertyEditor<Double> myEditor;

        public WeightProperty(boolean isWeightX) {
            super(null, isWeightX ? "Weight X" : "Weight Y");
            this.myIsWeightX = isWeightX;
        }

        @Override
        public Double getValue(RadComponent component) {
            if (component.getCustomLayoutConstraints() instanceof GridBagConstraints) {
                GridBagConstraints gbc = (GridBagConstraints)component.getCustomLayoutConstraints();
                return this.myIsWeightX ? gbc.weightx : gbc.weighty;
            }
            return 0.0;
        }

        @Override
        protected void setValueImpl(RadComponent component, Double value) throws Exception {
            if (component.getCustomLayoutConstraints() instanceof GridBagConstraints) {
                GridBagConstraints gbc = (GridBagConstraints)component.getCustomLayoutConstraints();
                if (this.myIsWeightX) {
                    gbc.weightx = value;
                } else {
                    gbc.weighty = value;
                }
                ((GridBagLayout)component.getParent().getLayout()).setConstraints(component.getDelegee(), gbc);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<Double> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new LabelPropertyRenderer();
            }
            LabelPropertyRenderer<Double> labelPropertyRenderer = this.myRenderer;
            if (labelPropertyRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadGridBagLayoutManager$WeightProperty", "getRenderer"));
            }
            return labelPropertyRenderer;
        }

        @Override
        public PropertyEditor<Double> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new PrimitiveTypeEditor<Double>(Double.class);
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadComponent component) {
            return !new Double(0.0).equals(this.getValue(component));
        }

        @Override
        public void resetValue(RadComponent component) throws Exception {
            this.setValue(component, 0.0);
        }
    }

    private static class ComponentInsetsProperty
    extends AbstractInsetsProperty<RadComponent> {
        public ComponentInsetsProperty() {
            super(null, "Insets");
        }

        @Override
        public Insets getValue(RadComponent component) {
            if (component.getCustomLayoutConstraints() instanceof GridBagConstraints) {
                GridBagConstraints gbc = (GridBagConstraints)component.getCustomLayoutConstraints();
                return gbc.insets;
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected void setValueImpl(RadComponent component, Insets value) throws Exception {
            if (component.getCustomLayoutConstraints() instanceof GridBagConstraints) {
                GridBagConstraints cellConstraints = (GridBagConstraints)component.getCustomLayoutConstraints();
                cellConstraints.insets = value;
                GridBagLayout layout = (GridBagLayout)component.getParent().getLayout();
                GridBagConstraints gbc = (GridBagConstraints)layout.getConstraints(component.getDelegee()).clone();
                gbc.insets = value;
                layout.setConstraints(component.getDelegee(), gbc);
            }
        }

        @Override
        public boolean isModified(RadComponent component) {
            return !this.getValue(component).equals(new Insets(0, 0, 0, 0));
        }

        @Override
        public void resetValue(RadComponent component) throws Exception {
            this.setValue(component, new Insets(0, 0, 0, 0));
        }
    }
}

