/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.FieldFormReference;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BoundFieldAssignmentInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = UIDesignerBundle.message("form.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/BoundFieldAssignmentInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.bound.field.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/BoundFieldAssignmentInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("BoundFieldAssignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/BoundFieldAssignmentInspection", "getShortName"));
        }
        return "BoundFieldAssignment";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/uiDesigner/inspections/BoundFieldAssignmentInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression lExpression = expression.getLExpression();
                if (lExpression instanceof PsiReferenceExpression) {
                    PsiReferenceExpression lExpr = (PsiReferenceExpression)lExpression;
                    PsiElement lElement = lExpr.resolve();
                    if (!(lElement instanceof PsiField)) {
                        return;
                    }
                    PsiField field = (PsiField)lElement;
                    PsiReference formReference = FormReferenceProvider.getFormReference(field);
                    if (!(formReference instanceof FieldFormReference)) {
                        return;
                    }
                    FieldFormReference ref = (FieldFormReference)formReference;
                    if (ref.isCustomCreate()) {
                        return;
                    }
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
                    if (method != null && "$$$setupUI$$$".equals(method.getName())) {
                        return;
                    }
                    holder.registerProblem((PsiElement)expression, UIDesignerBundle.message("inspection.bound.field.message", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/BoundFieldAssignmentInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }
}

