/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.uiDesigner.DesignSpacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;

public final class VSpacer
extends DesignSpacer {
    public VSpacer() {
        this.setSize(VSpacer.getHandleWidth(), 50);
    }

    private static int getHandleWidth() {
        return 11;
    }

    private static int getHandleHeight() {
        return 5;
    }

    protected void paintComponent(Graphics g) {
        int handleHeight = VSpacer.getHandleHeight();
        int handleWidth = VSpacer.getHandleWidth();
        int x = (this.getWidth() - handleWidth) / 2;
        VSpacer.drawHandle(g, x, 0);
        g.setColor(ourColor1);
        UIUtil.drawLine((Graphics)g, (int)(x + handleWidth / 2), (int)handleHeight, (int)(x + handleWidth / 2), (int)(handleHeight + 1));
        int y = this.getHeight() - handleHeight - 1;
        VSpacer.drawHandle(g, x, y);
        UIUtil.drawLine((Graphics)g, (int)(x + handleWidth / 2), (int)(y - 2), (int)(x + handleWidth / 2), (int)y);
        g.setColor(ourColor1);
        VSpacer.drawSpring(g, x + handleWidth / 2, handleHeight + 1, this.getHeight() - 2 * handleHeight - 4);
    }

    private static void drawHandle(Graphics g, int x, int y) {
        g.setColor(ourColor1);
        g.drawRect(x, y, 2, 4);
        UIUtil.drawLine((Graphics)g, (int)(x + 3), (int)(y + 2), (int)(x + 3 + 1 - 1), (int)(y + 2));
        g.drawRect(x += 4, y, 2, 4);
        UIUtil.drawLine((Graphics)g, (int)(x + 3), (int)(y + 2), (int)(x + 3 + 1 - 1), (int)(y + 2));
        g.drawRect(x += 4, y, 2, 4);
    }

    private static void drawSpring(Graphics g, int x, int y, int height) {
        for (int _y = y; _y < y + height - 1; _y += 4) {
            VSpacer.drawSpringPeriod(g, x, _y);
        }
    }

    private static void drawSpringPeriod(Graphics g, int x, int y) {
        g.setColor(ourColor2);
        UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)y, (int)(x + 2), (int)y);
        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + 1), (int)x, (int)(y + 1));
        UIUtil.drawLine((Graphics)g, (int)(x - 1), (int)(y + 2), (int)(x - 2), (int)(y + 2));
        g.setColor(ourColor3);
        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + 3), (int)x, (int)(y + 3));
    }

    public Dimension getMinimumSize() {
        return new Dimension(VSpacer.getHandleWidth(), VSpacer.getHandleHeight() * 2 + 4);
    }
}

