/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereLibertyFilesProvider;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public class WebSphereLibertyConfigAccessor
extends WebSphereLibertyFilesProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + WebSphereLibertyConfigAccessor.class.getName()));
    private final WebSphereModel myServerModel;
    private final Object myFileAccessLock = new Object();

    public WebSphereLibertyConfigAccessor(WebSphereModel serverModel) {
        super(serverModel);
        this.myServerModel = serverModel;
    }

    public WebSphereModel getServerModel() {
        return this.myServerModel;
    }

    private File getPathUnderServer(@NonNls String relativePath) {
        return new File(this.getServersDir(), this.myServerModel.SERVER_NAME + "/" + relativePath);
    }

    private File getServerConfigFile() {
        return this.getPathUnderServer("server.xml");
    }

    public File getLogFile() {
        return this.getPathUnderServer("logs/messages.log");
    }

    public long getStamp() {
        return CachedConfig.getStamp((File)this.getServerConfigFile());
    }

    public File getJmxFile() {
        return this.getPathUnderServer("workarea/com.ibm.ws.jmx.local.address");
    }

    public abstract class Processor {
        public void silentProcess() {
            if (!WebSphereLibertyConfigAccessor.this.getServerConfigFile().exists()) {
                return;
            }
            try {
                this.process();
            }
            catch (JDOMException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() throws JDOMException, IOException {
            Object object = WebSphereLibertyConfigAccessor.this.myFileAccessLock;
            synchronized (object) {
                File configFile = WebSphereLibertyConfigAccessor.this.getServerConfigFile();
                Document document = JDOMUtil.loadDocument((File)configFile);
                Element rootElement = document.getRootElement();
                if (this.doProcess(rootElement)) {
                    JDOMUtil.writeDocument((Document)document, (File)configFile, (String)"\n");
                }
            }
        }

        protected abstract boolean doProcess(Element var1);
    }
}

