/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.j2ee.webSphere.WebSphereBundle;
import com.intellij.j2ee.webSphere.configuration.WebSphereLibertyConfigAccessor;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLocalModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.openapi.util.Ref;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSphereLibertyConfig
extends CachedConfig<WebSphereLocalModel> {
    @NonNls
    private static final String FEATURE_MANAGER_ELEMENT = "featureManager";
    @NonNls
    private static final String FEATURE_ELEMENT = "feature";
    @NonNls
    private static final String LOCAL_CONNECTOR_TEXT = "localConnector-1.0";
    @NonNls
    private static final String EJB_LITE_TEXT = "ejbLite-3.1";
    @NonNls
    private static final String APPLICATION_MONITOR_ELEMENT = "applicationMonitor";
    @NonNls
    private static final String UPDATE_TRIGGER_ATTRIBUTE = "updateTrigger";
    @NonNls
    private static final String MBEAN_ATTRIBUTE_VALUE = "mbean";
    private static final Set<String> ejbFeatures = new HashSet<String>(Arrays.asList("webProfile-6.0", "webProfile-7.0", "zosLocalAdapters-1.0", "ejbLite-3.1", "ejbLite-3.2", "ejb-3.2", "ejbHome-3.2", "ejbPersistentTimer-3.2", "ejbRemote-3.2", "javaee-7.0"));
    private static final Map<CachedConfig.Key, WebSphereLibertyConfig> ourCache = new HashMap<CachedConfig.Key, WebSphereLibertyConfig>();
    private static final CachedConfig.Factory<WebSphereLocalModel, WebSphereLibertyConfig> ourFactory = new CachedConfig.Factory<WebSphereLocalModel, WebSphereLibertyConfig>(){

        @NotNull
        public CachedConfig.Key createKey(WebSphereLocalModel data) {
            CachedConfig.Key key = new CachedConfig.Key(new String[]{data.getHome(), data.SERVER_NAME});
            if (key == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereLibertyConfig$1", "createKey"));
            }
            return key;
        }

        @NotNull
        public WebSphereLibertyConfig createConfig(WebSphereLocalModel data) {
            WebSphereLibertyConfig webSphereLibertyConfig = new WebSphereLibertyConfig();
            if (webSphereLibertyConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereLibertyConfig$1", "createConfig"));
            }
            return webSphereLibertyConfig;
        }
    };
    private Boolean myJmxAdminEnabled;
    private Boolean myEjbFeatureEnabled;

    @Nullable
    private static WebSphereLibertyConfig getInstance(WebSphereLocalModel model) {
        return (WebSphereLibertyConfig)WebSphereLibertyConfig.get(ourCache, ourFactory, (Object)((Object)model));
    }

    protected long getStamp(WebSphereLocalModel data) {
        return data.getLibertyConfigAccessor().getStamp();
    }

    protected void update(WebSphereLocalModel data) {
        this.myJmxAdminEnabled = WebSphereLibertyConfig.doCheckJmxAdmin(data, false);
        this.myEjbFeatureEnabled = WebSphereLibertyConfig.doCheckEjbFeature(data, false);
    }

    public static void checkJmxAdmin(WebSphereLocalModel data) throws RuntimeConfigurationError {
        Boolean jmxAdminEnabled;
        WebSphereLibertyConfig instance = WebSphereLibertyConfig.getInstance(data);
        Boolean bl = jmxAdminEnabled = instance == null ? null : instance.myJmxAdminEnabled;
        if (!Boolean.TRUE.equals(jmxAdminEnabled)) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("error.jmx.administration.should.be.enabled", new Object[0]), jmxAdminEnabled == null ? null : () -> WebSphereLibertyConfig.doCheckJmxAdmin(data, true));
        }
    }

    public static void checkEjbFeature(WebSphereLocalModel data) throws RuntimeConfigurationError {
        Boolean ejbLiteEnabled;
        WebSphereLibertyConfig instance = WebSphereLibertyConfig.getInstance(data);
        Boolean bl = ejbLiteEnabled = instance == null ? null : instance.myEjbFeatureEnabled;
        if (!Boolean.TRUE.equals(ejbLiteEnabled)) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("error.ejb.feature.should.be.enabled", new Object[0]), ejbLiteEnabled == null ? null : () -> WebSphereLibertyConfig.doCheckEjbFeature(data, true));
        }
    }

    @Nullable
    private static Boolean doCheckJmxAdmin(WebSphereLocalModel data, final boolean fix) {
        final Ref resultRef = new Ref();
        WebSphereLibertyConfigAccessor webSphereLibertyConfigAccessor = data.getLibertyConfigAccessor();
        ((Object)((Object)webSphereLibertyConfigAccessor)).getClass();
        new WebSphereLibertyConfigAccessor.Processor(webSphereLibertyConfigAccessor){

            @Override
            protected boolean doProcess(Element rootElement) {
                Element applicationMonitor;
                String updateTrigger;
                boolean result = true;
                Element featureManager = WebSphereLibertyConfig.getOrCreateChild((Element)rootElement, (String)WebSphereLibertyConfig.FEATURE_MANAGER_ELEMENT);
                Element localConnector = null;
                for (Element feature : WebSphereLibertyConfig.getChildren((Element)featureManager, (String)WebSphereLibertyConfig.FEATURE_ELEMENT)) {
                    if (!WebSphereLibertyConfig.LOCAL_CONNECTOR_TEXT.equals(feature.getText())) continue;
                    localConnector = feature;
                    break;
                }
                if (localConnector == null) {
                    result = false;
                    localConnector = new Element(WebSphereLibertyConfig.FEATURE_ELEMENT);
                    localConnector.addContent(WebSphereLibertyConfig.LOCAL_CONNECTOR_TEXT);
                    featureManager.addContent(localConnector);
                }
                if (!WebSphereLibertyConfig.MBEAN_ATTRIBUTE_VALUE.equals(updateTrigger = (applicationMonitor = WebSphereLibertyConfig.getOrCreateChild((Element)rootElement, (String)WebSphereLibertyConfig.APPLICATION_MONITOR_ELEMENT)).getAttributeValue(WebSphereLibertyConfig.UPDATE_TRIGGER_ATTRIBUTE))) {
                    result = false;
                    applicationMonitor.setAttribute(WebSphereLibertyConfig.UPDATE_TRIGGER_ATTRIBUTE, WebSphereLibertyConfig.MBEAN_ATTRIBUTE_VALUE);
                }
                resultRef.set((Object)result);
                return !result && fix;
            }
        }.silentProcess();
        return (Boolean)resultRef.get();
    }

    @Nullable
    private static Boolean doCheckEjbFeature(WebSphereLocalModel data, final boolean fix) {
        final Ref resultRef = new Ref();
        WebSphereLibertyConfigAccessor webSphereLibertyConfigAccessor = data.getLibertyConfigAccessor();
        ((Object)((Object)webSphereLibertyConfigAccessor)).getClass();
        new WebSphereLibertyConfigAccessor.Processor(webSphereLibertyConfigAccessor){

            @Override
            protected boolean doProcess(Element rootElement) {
                boolean result = true;
                Element featureManager = WebSphereLibertyConfig.getOrCreateChild((Element)rootElement, (String)WebSphereLibertyConfig.FEATURE_MANAGER_ELEMENT);
                Element ejbLite = null;
                for (Element feature : WebSphereLibertyConfig.getChildren((Element)featureManager, (String)WebSphereLibertyConfig.FEATURE_ELEMENT)) {
                    if (!ejbFeatures.contains(feature.getText())) continue;
                    ejbLite = feature;
                    break;
                }
                if (ejbLite == null) {
                    result = false;
                    ejbLite = new Element(WebSphereLibertyConfig.FEATURE_ELEMENT);
                    ejbLite.addContent(WebSphereLibertyConfig.EJB_LITE_TEXT);
                    featureManager.addContent(ejbLite);
                }
                resultRef.set((Object)result);
                return !result && fix;
            }
        }.silentProcess();
        return (Boolean)resultRef.get();
    }
}

