/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.admin;

import com.intellij.j2ee.webSphere.configuration.WebSphereLibertyConfigAccessor;
import com.intellij.j2ee.webSphere.deploymentSource.LooseApplicationDeploymentSource;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereDeploymentModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.ModuleTypeWrapper;
import com.intellij.javaee.oss.admin.jmx.JavaeeJmxAdminServerBase;
import com.intellij.javaee.oss.admin.jmx.JmxAdminException;
import com.intellij.javaee.oss.util.AbstractConnectorCommand;
import com.intellij.javaee.oss.util.ConfigBase;
import com.intellij.javaee.oss.util.ModuleTypeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

public class WebSphereAdminLibertyServerImpl
extends JavaeeJmxAdminServerBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + WebSphereAdminLibertyServerImpl.class.getName()));
    private static final String DEPLOYED_STATE = "STARTED";
    private static final Set<String> ACTIVATING_STATES = ContainerUtil.set((Object[])new String[]{"STOPPED", "STARTING", "PARTIALY_STARTED", "INSTALLED"});
    private final Map<String, Element> myApplicationId2Element = new HashMap<String, Element>();
    private final Set<String> myFirstDeploymentIds = new HashSet<String>();
    private final WebSphereLibertyConfigAccessor myConfigAccessor;
    private final File myJmxFile;
    private final boolean myLocalhost;
    private final boolean myLocal;
    private String myJmxUrl;

    public WebSphereAdminLibertyServerImpl(WebSphereLibertyConfigAccessor configAccessor, boolean localhost) {
        this.myJmxFile = configAccessor.getJmxFile();
        this.myConfigAccessor = configAccessor;
        this.myLocalhost = localhost;
        this.myLocal = this.myConfigAccessor.getServerModel().getCommonModel().isLocal();
    }

    public boolean doConnect() {
        if (!this.myLocalhost) {
            return true;
        }
        if (this.myJmxUrl == null) {
            if (!this.myJmxFile.exists()) {
                this.getLogger().debug("JMX file not found: " + this.myJmxFile.getAbsolutePath());
                return false;
            }
            try {
                this.myJmxUrl = FileUtil.loadFile((File)this.myJmxFile);
            }
            catch (IOException e) {
                this.getLogger().debugEx((Exception)e);
                return false;
            }
        }
        return super.doConnect();
    }

    protected JavaeeJmxAdminServerBase.JmxAdminCommandBase<Boolean> createConnectCommand() {
        return new ConnectorCommandBase<Boolean>(){

            protected Boolean doExecute(MBeanServerConnection connection) throws JMException, IOException {
                return true;
            }
        };
    }

    protected boolean isUndeploySyncNeeded() {
        return this.myLocalhost;
    }

    public void startDeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        final JavaeeJmxAdminServerBase.DeploymentContextImpl context = new JavaeeJmxAdminServerBase.DeploymentContextImpl(deployment, source, callback);
        new JavaeeJmxAdminServerBase.DeploymentModelOperation(context){

            protected boolean isFailOnError() {
                return true;
            }

            @Nullable
            protected Boolean doPerform() throws JmxAdminException {
                new ApplicationConfigProcessor(){

                    @Override
                    protected boolean processApplication(Element rootElement, Element applicationElement, String id) {
                        if (WebSphereAdminLibertyServerImpl.this.myLocal && WebSphereAdminLibertyServerImpl.this.myFirstDeploymentIds.add(id) && applicationElement != null) {
                            WebSphereAdminLibertyServerImpl.this.doStartDeploy(context);
                        } else {
                            WebSphereAdminLibertyServerImpl.this.doStartDeployWithUndeploy(context);
                        }
                        return false;
                    }
                }.process((JavaeeJmxAdminServerBase.DeploymentContext)context);
                return null;
            }
        }.perform();
    }

    protected boolean doDeploy(final JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        return new ApplicationConfigProcessor(){

            @Override
            protected boolean processApplication(Element rootElement, Element applicationElement, String id) {
                if (applicationElement == null) {
                    applicationElement = WebSphereAdminLibertyServerImpl.this.myApplicationId2Element.containsKey(id) ? ((Element)WebSphereAdminLibertyServerImpl.this.myApplicationId2Element.get(id)).clone() : new Element("application").setAttribute("id", id);
                    rootElement.addContent(applicationElement);
                }
                WebSphereDeploymentModel deploymentModel = (WebSphereDeploymentModel)context.getDeploymentModel();
                DeploymentSource deploymentSource = deploymentModel.getDeploymentSource();
                ModuleTypeWrapper type = ModuleTypeUtil.getModuleType((DeploymentModel)deploymentModel);
                String artifactType = type != null ? type.getName() : null;
                String location = context.getSource().getAbsolutePath();
                applicationElement.setAttribute("location", deploymentSource instanceof LooseApplicationDeploymentSource ? ((LooseApplicationDeploymentSource)deploymentSource).artifact2looseAppLocation(location) : location);
                applicationElement.setAttribute("name", id);
                WebSphereAdminLibertyServerImpl.setOrRemoveAttribute(applicationElement, "type", artifactType);
                String contextRoot = !deploymentModel.isDefaultContextRoot() ? deploymentModel.getContextRoot() : null;
                WebSphereAdminLibertyServerImpl.setOrRemoveAttribute(applicationElement, "context-root", contextRoot);
                return true;
            }
        }.process(context);
    }

    protected boolean doUndeploy(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        return new ApplicationConfigProcessor(){

            @Override
            protected boolean processApplication(Element rootElement, Element applicationElement, String id) {
                if (applicationElement != null) {
                    WebSphereAdminLibertyServerImpl.this.myApplicationId2Element.put(id, applicationElement.clone());
                    rootElement.removeContent((Content)applicationElement);
                }
                return true;
            }
        }.process(context);
    }

    protected DeploymentStatus doGetDeploymentStatus(final JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        final Ref statusRef = new Ref((Object)DeploymentStatus.NOT_DEPLOYED);
        new ConnectorCommandBase(){

            protected DeploymentStatus doExecute(MBeanServerConnection connection) throws JMException, IOException {
                ObjectName objectName = AbstractConnectorCommand.createObjectName((String)("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + WebSphereAdminLibertyServerImpl.getId(context)));
                String state = (String)AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)objectName, (String)"State");
                if (state != null) {
                    LOG.debug("state: " + state);
                    if (WebSphereAdminLibertyServerImpl.DEPLOYED_STATE.equals(state)) {
                        statusRef.set((Object)DeploymentStatus.DEPLOYED);
                    } else if (ACTIVATING_STATES.contains(state)) {
                        statusRef.set((Object)DeploymentStatus.ACTIVATING);
                    } else {
                        statusRef.set((Object)DeploymentStatus.FAILED);
                    }
                }
                return null;
            }
        }.adminExecute();
        return (DeploymentStatus)statusRef.get();
    }

    private static void setOrRemoveAttribute(Element applicationElement, String name, String value) {
        if (value == null) {
            applicationElement.removeAttribute(name);
        } else {
            applicationElement.setAttribute(name, value);
        }
    }

    private static String getId(JavaeeJmxAdminServerBase.DeploymentContext context) {
        return WebSphereModel.getLibertyDeploymentId(context.getDeploymentModel());
    }

    private abstract class ApplicationConfigProcessor
    extends ConfigBase {
        private ApplicationConfigProcessor() {
        }

        public boolean process(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
            final String id = WebSphereAdminLibertyServerImpl.getId(context);
            try {
                WebSphereLibertyConfigAccessor webSphereLibertyConfigAccessor = WebSphereAdminLibertyServerImpl.this.myConfigAccessor;
                ((Object)((Object)webSphereLibertyConfigAccessor)).getClass();
                new WebSphereLibertyConfigAccessor.Processor(webSphereLibertyConfigAccessor){

                    @Override
                    protected boolean doProcess(Element rootElement) {
                        Element applicationElement = ApplicationConfigProcessor.getChild((Element)rootElement, (String)"application", (String)"id", (String)id);
                        return ApplicationConfigProcessor.this.processApplication(rootElement, applicationElement, id);
                    }
                }.process();
                return true;
            }
            catch (IOException e) {
                throw new JmxAdminException((Exception)e);
            }
            catch (JDOMException e) {
                throw new JmxAdminException((Exception)((Object)e));
            }
        }

        protected abstract boolean processApplication(Element var1, Element var2, String var3);
    }

    private abstract class ConnectorCommandBase<T>
    extends JavaeeJmxAdminServerBase.JmxAdminCommandBase<T> {
        private ConnectorCommandBase() {
            super((JavaeeJmxAdminServerBase)WebSphereAdminLibertyServerImpl.this);
        }

        protected String getJmxUrl() {
            return WebSphereAdminLibertyServerImpl.this.myJmxUrl;
        }

        protected String getHost() {
            throw new UnsupportedOperationException();
        }

        protected int getJmxPort() {
            throw new UnsupportedOperationException();
        }
    }
}

