/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlNamespaceType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.annotations.NotNull;

public class FtlTemplateType
extends FtlNamespaceType {
    public static final Key<Boolean> PROCESSING_NAMESPACE = Key.create((String)"PROCESSING_NAMESPACE");
    private final FtlFile myTemplateFile;

    public FtlTemplateType(@NotNull FtlFile templateFile) {
        if (templateFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFile", "com/intellij/freemarker/psi/variables/FtlTemplateType", "<init>"));
        }
        this.myTemplateFile = templateFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlTemplateType)) {
            return false;
        }
        FtlTemplateType that = (FtlTemplateType)o;
        return !(this.myTemplateFile != null ? !((Object)((Object)this.myTemplateFile)).equals((Object)that.myTemplateFile) : that.myTemplateFile != null);
    }

    public int hashCode() {
        return this.myTemplateFile != null ? ((Object)((Object)this.myTemplateFile)).hashCode() : 0;
    }

    @Override
    public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, ResolveState state) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/variables/FtlTemplateType", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/variables/FtlTemplateType", "processDeclarations"));
        }
        if (!PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                FtlTemplateType templateType;
                FtlAssignmentDeclaration declaration;
                FtlExpression expression;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/variables/FtlTemplateType$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/variables/FtlTemplateType$1", "execute"));
                }
                if (element instanceof FtlAssignmentDeclaration && ((expression = (declaration = (FtlAssignmentDeclaration)element).getNamespaceExpression()) != null ? (templateType = FtlPsiUtil.asInstanceOf(expression.getType(), FtlTemplateType.class)) != null && FtlTemplateType.this.myTemplateFile.isEquivalentTo((PsiElement)templateType.getTemplateFile()) : declaration.getContainingFile() == FtlTemplateType.this.myTemplateFile)) {
                    return processor.execute(element, state);
                }
                return true;
            }
        }, (PsiElement)place, null, (ResolveState)(state = FtlAssignmentType.allowAssignments(state, FtlAssignmentType.ASSIGN)).put(PROCESSING_NAMESPACE, (Object)true))) {
            return false;
        }
        return this.myTemplateFile.getRootTag().processDirectiveDeclarations(processor, state, null, true);
    }

    @NotNull
    public FtlFile getTemplateFile() {
        FtlFile ftlFile = this.myTemplateFile;
        if (ftlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlTemplateType", "getTemplateFile"));
        }
        return ftlFile;
    }
}

