/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlMacroLoopVariable
extends FtlCompositeElement
implements FtlVariable {
    public FtlMacroLoopVariable(ASTNode node) {
        super(node);
    }

    @NotNull
    private PsiElement getNameElement() {
        PsiElement element = this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
        assert (element != null);
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlMacroLoopVariable", "getNameElement"));
        }
        return psiElement;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlMacroLoopVariable", "getUseScope"));
        }
        return globalSearchScope;
    }

    public String getName() {
        return this.getNameElement().getText();
    }

    @Override
    public FtlType getType() {
        FtlMacro macro = (FtlMacro)this.getParent();
        FtlSignatureDirective directive = macro.resolveMacro();
        if (directive == null) {
            return null;
        }
        int index = Arrays.asList(macro.getLoopVariables()).indexOf(this);
        return directive.getLoopVariableTypes().get(index);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/variables/FtlMacroLoopVariable", "setName"));
        }
        FtlXmlRootTag tag = FtlPsiUtil.parseFtlFile("<@a b ; " + name + "/>", this.getProject());
        FtlMacro macro = (FtlMacro)tag.getSubTags()[0];
        FtlMacroLoopVariable variable = macro.getLoopVariables()[0];
        this.getNode().replaceChild(this.getNameElement().getNode(), variable.getNameElement().getNode());
        return this;
    }
}

