/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.psi.ResolveState;
import java.util.EnumSet;

class ResolveStateParameters {
    final boolean honorAssigns;
    final boolean resolvingMacro;
    final boolean processingNamespace;
    final EnumSet<FtlAssignmentType> allowedAssignments;

    ResolveStateParameters(boolean honorAssigns, ResolveState state) {
        this.honorAssigns = honorAssigns;
        this.resolvingMacro = state.get(FtlQualifiedReference.RESOLVING_MACRO) == Boolean.TRUE;
        this.processingNamespace = state.get(FtlTemplateType.PROCESSING_NAMESPACE) == Boolean.TRUE;
        this.allowedAssignments = (EnumSet)state.get(FtlAssignmentType.TYPE_KEY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolveStateParameters)) {
            return false;
        }
        ResolveStateParameters that = (ResolveStateParameters)o;
        if (this.honorAssigns != that.honorAssigns) {
            return false;
        }
        if (this.processingNamespace != that.processingNamespace) {
            return false;
        }
        if (this.resolvingMacro != that.resolvingMacro) {
            return false;
        }
        return !(this.allowedAssignments != null ? !this.allowedAssignments.equals(that.allowedAssignments) : that.allowedAssignments != null);
    }

    public int hashCode() {
        int result = this.honorAssigns ? 1 : 0;
        result = 31 * result + (this.resolvingMacro ? 1 : 0);
        result = 31 * result + (this.processingNamespace ? 1 : 0);
        result = 31 * result + (this.allowedAssignments != null ? this.allowedAssignments.hashCode() : 0);
        return result;
    }

    public ResolveState createState() {
        ResolveState state = ResolveState.initial().put(FtlQualifiedReference.RESOLVING_MACRO, (Object)this.resolvingMacro).put(FtlTemplateType.PROCESSING_NAMESPACE, (Object)this.processingNamespace);
        if (this.allowedAssignments != null) {
            state = state.put(FtlAssignmentType.TYPE_KEY, this.allowedAssignments);
        }
        return state;
    }
}

